#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import *
from PyQt4.QtGui import * 

import socket
import string
import random
import Ui_baseconfigwizard
import os
import sys

from nosferatu import bacresources, prettynames, auto_types



# TODO: move this into base_classes




class newdatacenterwizard(QtGui.QWizard, Ui_baseconfigwizard.Ui_Wizard,):
  ''' 
  '''
  
  def __init__(self, TEMPLATES_PATH ):
    super(newdatacenterwizard, self).__init__()
    self.setupUi(self)
    self.setWindowTitle("New Datacenter Wizard")
    self.groupBox.setTitle('Welcome to the new Datacenter Wizard.')
    self.TEMPLATES_PATH = TEMPLATES_PATH
    # configuration info that has to be provided:
    self.newDCinfo = {                           
             'dcname'   : ['Datacenter Name','Name of the Datacenter, e.g. Company Name or OU <br>e.g. <i>MyCompany</i>',''],
             'hostname' : ['Hostname','Hostname of the Bacula Server (short name) <br>e.g. <i> bacula </i>',''],
             'hostaddress'  : ['Hostaddress','DNS Name of the Bacula Server (FQDN) <br>e.g. <i>bacula.dass-it.de</i>',''],
             }


    
    introtext = 'Please provide the following information:<br><ul>'
    #self.groupBox_2.setTitle('please provide the following information for the %s:' % (prettynames.PrettyNames[resource.resourcetype]))
    
    for name,info in self.newDCinfo.iteritems():
       introtext +=  '<li><b>' + info[0] + '</b><br>' + info[1] + '</li>'
    introtext +='</ul>'   
    
    self.introtextEdit.setHtml(introtext)
    
    row = 0
    # for name,info in self.newDCinfo.iteritems():
    for name in sorted(self.newDCinfo.keys()):
      info = self.newDCinfo[name]
      newlabel = QtGui.QLabel(self.scrollAreaWidgetContents)
      newlabel.setText(info[0])
      
      self.gridLayout_4.addWidget(newlabel, row, 0, 1, 1)
      newwidget = QtGui.QLineEdit(self.scrollAreaWidgetContents)
      newwidget.setToolTip(info[1]) 
      self.wizardPage2.registerField(name + '*', newwidget)
      self.gridLayout_4.addWidget(newwidget, row, 1, 1, 1)
      
      
      if name == 'hostaddress':
          newButton = QtGui.QPushButton(self.scrollAreaWidgetContents)
          newButton.setText('check')
          self.gridLayout_4.addWidget(newButton, row, 2, 1, 1)
          self.addressLineEdit = newwidget
          self.connect(newButton,
                       SIGNAL("clicked()"),
                       self.onaddrCheckButtonClicked
                       )
      
      
      # find validator to ensure ony valid hostnames can be enteredTODO: 
      #if name == 'hostname':
      #  validator = QtGui.QValidator()
      #  QtGui.QValidator.
      #  newwidget.setValidator(validator)
      row += 1
   

  def initializePage(self,pagenumber):
    
    
    if pagenumber ==  2:  # overview page
      
      for name,info in self.newDCinfo.iteritems(): # safe registerd fields to DCinfo
        self.newDCinfo[name][2] = unicode(self.field(name).toString()) 
      
      dc = bacresources.DataCenter(os.path.normpath( self.TEMPLATES_PATH + '/503_psql.dmdz'))  # use this template
    
      dcname = self.newDCinfo['dcname'][2]
      hostname = self.newDCinfo['hostname'][2]
      hostaddress = self.newDCinfo['hostaddress'][2]
      
      DIRNAME = hostname + '-dir'
      FDNAME = hostname + '-fd'
      SDNAME = hostname + '-sd'
      MONNAME = hostname + '-mon'
      
      # Passwords
      pw_DIR_SD     = bacresources.genPw(None,32)    # director - storage daemon
      pw_DIR_FD     = bacresources.genPw(None,32)    # director - filedaemon
      pw_DIR_CON    = bacresources.genPw(None,32)    # director - console
      pw_DIR_MON    = bacresources.genPw(None,32 )   # director - monitoring console
      
      dc.setName(dcname)
      
      # Director Config
      # set the Name of the Director resource in the Director Config
      directorlist = list(dc.directors)
      directorconfig = directorlist[0] 
      directorconfigDir = directorconfig.getResourceByName('bacula-dir')
      directorconfigDir.setName(DIRNAME)
      directorconfigDir.setItemValue('password', pw_DIR_CON)
    
      # set the Client name in 'DefaultJob' JobDefs
      directorconfigJobDefs = directorconfig.getResourceByName('DefaultJob')
      directorconfigJobDefs.setItemValue('client', FDNAME)
      
      # set the Client name in 'RestoreFiles' Job
      directorrestorefiles = directorconfig.getResourceByName('RestoreFiles')
      directorrestorefiles.setItemValue('client', FDNAME)
      
      # set the Name of the Client Resource and the address 'bacula-fd'
      directorclientresource = directorconfig.getResourceByName('bacula-fd')
      directorclientresource.setName(FDNAME)
      # set the password
      directorclientresource.setItemValue('password', pw_DIR_FD)
      # set the address
      directorclientresource.setItemValue('address',hostaddress)
        
      # set the Address of the storage Resource 'File'
      directorstorageresource = directorconfig.getResourceByName('File')
      directorstorageresource.setItemValue('address',hostaddress)
      directorstorageresource.setItemValue('password', pw_DIR_SD)
      
      # set the Name of the Monitor Console Entry
      directormonitorconsole = directorconfig.getResourceByName('bacula-mon')
      directormonitorconsole.setName(MONNAME)
      directormonitorconsole.setItemValue('password', pw_DIR_MON)
     
      # Filedaemon Config
      fdlist = list(dc.filedaemons)
      fdconfig = fdlist[0]
      # set the Name of the Director resource in the Filedaemon Config
      filedaemonconfigdir = fdconfig.getResourceByName('bacula-dir')
      filedaemonconfigdir.setName(DIRNAME)
      filedaemonconfigdir.setItemValue('password', pw_DIR_FD)
      
      # set the Name of the Filedaemon resource in the Filedaemon Config
      filedaemonconfigfd =  fdconfig.getResourceByName('bacula-fd')
      filedaemonconfigfd.setName(FDNAME)
      
      # set the Name of the Director in the messages Resource in the Filedaemon Config
      filedaemonconfigmsg = fdconfig.getResourceByName('Standard')
      filedaemonconfigmsg.setItemValue('director', DIRNAME +' = all,!skipped,!restored')
      
     
      # Storage Daemon Config
      sdlist = list(dc.storagedaemons)
      sdconfig = sdlist[0]
      # set the Name for the Storage Daemon
      storagedaemonconfigsd = sdconfig.getResourceByName('bacula-sd')
      storagedaemonconfigsd.setName(SDNAME)
    
      # set the Director Entry
      storagedaemonconfigdir = sdconfig.getResourceByName('bacula-dir')
      storagedaemonconfigdir.setName(DIRNAME)
      storagedaemonconfigdir.setItemValue('password', pw_DIR_SD)
      
      # set the Messages Resource
      storagedaemonconfigmsg = sdconfig.getResourceByName('Standard')
      storagedaemonconfigmsg.setItemValue('director', DIRNAME +' = all,!skipped,!restored')
    
    
    
      # Console Config
      consoleslist = list(dc.consoles)
      consoleconfig = consoleslist[0]
      # set the name for the Director
      consoleconfigdir = consoleconfig.getResourceByName('bacula-dir')
      consoleconfigdir.setName(DIRNAME)
      # set the address of the Director
      consoleconfigdir.setItemValue('address', hostaddress)
      consoleconfigdir.setItemValue('password', pw_DIR_CON)
      
      filename = u''
      while not filename:
          filename = unicode(QFileDialog.getSaveFileName(self
                                 ,self.tr('Save Datacenter file')
                                 ,dc.getName()
                                 ,self.tr('dassModus datacenter .dmdz files (*.dmdz)'))
                      )
      self.filename = filename
      dc.setFileName(filename)
      dc.safeDatacenter()
      
      previewtext = 'A new datacenter with the following configuration: <p><ul>'  
      for name,info in self.newDCinfo.iteritems():
        #self.newDCinfo[name][2] = str(self.field(name).toString())
        previewtext += '<li><i>' + info[0] + '</i>:<b>' + self.field(name).toString()+'</b></li>'
      previewtext += '</ul></p>'
      previewtext += 'has been saved to <p><i>' + filename + '<i></p>' + ' and will be loaded automatically'
      self.previewtextEdit.setHtml(previewtext)
      
      
    
  
  def onpwgenPasswdClicked(self):
    self.passwordLineEdit.setText(bacresources.genPw(None,32))
    
  def onaddrCheckButtonClicked(self):
    hostname = unicode(self.addressLineEdit.text())
    ip = self.check_hostname(hostname) 
    if ip != None:
      reply = QMessageBox.information(self,
                                   "hostname OK",
                                   "check successful: \n\n \"%s\" \n is at\n %s" % (hostname, ip) ,
                                   QMessageBox.Ok)
    else:
      reply = QMessageBox.warning(self,
                                   "hostname ERROR",
                                   "\"%s\" can NOT be resolved!" % (hostname) ,
                                   QMessageBox.Ok)


	
  def check_hostname(self,hostname):
    '''
    try to resolve the given hostname
    returns the IP or NONE if not resolvable
    '''
    if len(hostname) == 0:
      return None
    try:
      ip = socket.gethostbyname(hostname)
      return ip
    except:
      return None
  


if __name__ == "__main__":
  import sys
#def main():
  print "started"   
  app = QtGui.QApplication(sys.argv)
  app.setOrganizationDomain("dass-it.de")
  app.setOrganizationName("dassIT GmbH")
  app.setApplicationName("dassModus")
  app.setWindowIcon(QIcon(":/icons/dassit_logo.png")) 
  
  wizard = newdatacenterwizard()
  if wizard.exec_():
    dc = bacresources.DataCenter('templates/503_psql.dmdz')  # use this template
    
    dcname = wizard.newDCinfo['dcname'][2]
    hostname = wizard.newDCinfo['hostname'][2]
    hostaddress = wizard.newDCinfo['hostaddress'][2]
    
    DIRNAME = hostname + '-dir'
    FDNAME = hostname + '-fd'
    SDNAME = hostname + '-sd'
    
    
    dc.setName(dcname)
    
    # Director Config
    # set the Name of the Director resource in the Director Config
    directorlist = list(dc.directors)
    directorconfig = directorlist[0] 
    directorconfigDir = directorconfig.getResourceByName('bacula-dir')
    directorconfigDir.setName(DIRNAME)
    
    # set the Client name in 'DefaultJob' JobDefs
    directorconfigJobDefs = directorconfig.getResourceByName('DefaultJob')
    directorconfigJobDefs.setItemValue('client', FDNAME)
    
    # set the Client name in 'RestoreFiles' Job
    directorrestorefiles = directorconfig.getResourceByName('RestoreFiles')
    directorrestorefiles.setItemValue('client', FDNAME)
    
    # set the Name of the Client Resource and the address 'bacula-fd'
    directorclientresource = directorconfig.getResourceByName('bacula-fd')
    directorclientresource.setName(FDNAME)
    # set the Address
    directorclientresource.setItemValue('address', hostaddress)
    
    # set the Address of the storage Resource 'File'
    directorstorageresource = directorconfig.getResourceByName('File')
    directorstorageresource.setItemValue('address', hostaddress)
    
    
    # Filedaemon Config
    fdlist = list(dc.filedaemons)
    fdconfig = fdlist[0]
    # set the Name of the Director resource in the Filedaemon Config
    filedaemonconfigdir = fdconfig.getResourceByName('bacula-dir')
    filedaemonconfigdir.setName(DIRNAME)
    
    # set the Name of the Filedaemon resource in the Filedaemon Config
    filedaemonconfigfd =  fdconfig.getResourceByName('bacula-fd')
    filedaemonconfigfd.setName(FDNAME)
    
    # set the Name of the Director in the messages Resource in the Filedaemon Config
    filedaemonconfigmsg = fdconfig.getResourceByName('Standard')
    filedaemonconfigmsg.setItemValue('director', DIRNAME +' = all,!skipped,!restored')
    
    
    # Storage Daemon Config
    sdlist = list(dc.storagedaemons)
    sdconfig = sdlist[0]
    # set the Name for the Storage Daemon
    storagedaemonconfigsd = sdconfig.getResourceByName('bacula-sd')
    storagedaemonconfigsd.setName(SDNAME)
    
    # set the Director Entry
    storagedaemonconfigdir = sdconfig.getResourceByName('bacula-dir')
    storagedaemonconfigdir.setName(DIRNAME)
    
    # set the Messages Resource
    storagedaemonconfigmsg = sdconfig.getResourceByName('Standard')
    storagedaemonconfigmsg.setItemValue('director', DIRNAME +' = all,!skipped,!restored')
    
    
    
    # Console Config
    consoleslist = list(dc.consoles)
    consoleconfig = consoleslist[0]
    # set the name for the Director
    consoleconfigdir = consoleconfig.getResourceByName('bacula-dir')
    consoleconfigdir.setName(DIRNAME)
    # set the address of the Director
    consoleconfigdir.setItemValue('address', hostaddress)
    
    
    
    
    filename = unicode(QFileDialog.getSaveFileName(wizard
                                 ,wizard.tr('Save Datacenter file')
                                 ,dc.getName()
                                 ,wizard.tr('dassModus datacenter .dmdz files (*.dmdz)'))
                      )
    dc.setFileName(filename)
    dc.safeDatacenter()
    #filename = QtGui.QFileDialog()
    
    #dc.setFileName(filename)
  else:
    print "no"
  #wizard.show()
  
  
  sys.exit(app.exec_())
  
  
