# 
# Copyright  (c)  2004-2009  dass IT GmbH, Koeln, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# $Id: dassbuild.spec 1251 2020-09-01 14:30:04Z joergs $

Name:           dassbuild
URL:            https://trac.dass-it.de/pub/
License:        GPL-2.0-or-later
Group:          Development/Tools/Building
Autoreqprov:    on
Summary:        Scripts for RPM building
Version:        1.0
Release:        0
Requires:       build
Source:         %{name}_%{version}.orig.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch
%if 0%{?suse_version}
BuildRequires:  gzip tar
%endif

%description
dassbuild is a collection of tools for easier building RPMs directly from subversion repositories.
It uses tools like (SuSE) build, osc and Subversion.

Authors:
--------
       Joerg Steffens

%prep
%setup -c

%build

%install
mkdir -p $RPM_BUILD_ROOT/etc/dassbuild/
mkdir -p $RPM_BUILD_ROOT/usr/bin/
install -m 644 etc/dassbuild/dassbuild.conf $RPM_BUILD_ROOT/etc/dassbuild/
install -m 755 usr/bin/*.sh $RPM_BUILD_ROOT/usr/bin/
# don't install dassbuild_all.pl,
# because it is outdated

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%dir /etc/dassbuild/
/usr/bin/dassbuild*.sh
/usr/bin/dass_sign_rpm.sh
/usr/bin/make_and_publish_sles_patch_description.sh
%config(noreplace) /etc/dassbuild/*
%doc doc/* macros
