#!/usr/bin/python
# -*- coding: utf-8 -*-
"""Classes and functions for configuration file handling
"""

import sys 
import re
import resource
import directive

RESOURCE_TYPES = ('dird', 'console', 'filed', 'stored')

rxp_item = re.compile('\s*(?P<Name>[\S]+)\s*=\s*(?P<Value>.*)$') # xxx = xxx matchen
rxp_openbrace = re.compile('\s*(?P<Name>[\S ]+)=?\s+{.*')    # match xxx {
rxp_closebrace = re.compile('.*}.*')               # match }
rxp_comment = re.compile('^\s*#.*')



#'dird', 'console', 'filed' or 'stored'
class Config(object):
    """Class for bacula configuration access"""
    
    def __init__(self, resource_type, filename=""):
        self.resource_type = resource_type
        self.filename = filename
        self.resources = resource.Resource(level=0)

    def read(self):
        print "reading %s" % self.filename
        self.parse()
        print self.resources
        
    
    def write(self):
        pass
    
    def parse(self):
        multiRes = set(['Run','File','Ip']) # entries, which can be multiple times in a ressource
        f = open(self.filename)         
        dirRes=[] # Liste der Director Ressourcen
        curRes = self.resources
        braceLevel = 0;
        tmpRes = {}
        treeindex=range(10)
        treeindex[0]=curRes
       
        print resource.directives
        
        for line in f:
                #print braceLevel,line
            commentline = rxp_comment.match(line)
            if commentline:
                curRes.add_comment(line.strip())
                continue
            print braceLevel
            openbraceline = rxp_openbrace.match(line)
            closebraceline = rxp_closebrace.match(line)
            item = rxp_item.match(line)
            
            if openbraceline:
                braceLevel += 1
                resname = openbraceline.group("Name")
                
                if not resname in resource.directives:
                    raise "Unknown Resource: %s" % resname

                print resname
                newRes = eval("resource.%s(braceLevel)" % resname)
                print newRes
                curRes.add_item(newRes)
                treeindex[braceLevel]=curRes;
                curRes = newRes
            elif closebraceline:
                braceLevel -= 1
                curRes = treeindex[braceLevel]           
            elif item:
                name = item.group("Name")
                value = item.group("Value")
                curRes.add_item(directive.Item(name, value))
    
    
class DirdConfig(Config):
    
    def __init__(self, filename=""):
        Config.__init__(self, 'dird', filename)
        
class ConsoleConfig(Config):
    pass

class FiledConfig(Config):
    pass

class StoredConfig(Config):
    pass

if __name__ == "__main__":
    
    dirdcfg = DirdConfig("../conf/bacula-dir.conf")
    dirdcfg.read()
    
    sys.exit(0)
