#!/usr/bin/python
# -*- coding: utf-8 -*-
"""Classes and functions for configuration file handling
"""

import sys 
import re
import resource
import directive

RESOURCE_TYPES = ('dird', 'console', 'filed', 'stored')

rxp_item = re.compile('^\\s*(\\w[\\w ]*\\w+)\\s*\\=(.*)') # xxx = xxx matchen
rxp_item2 = re.compile('^\\s*(\\w[\\w ]*\\w+)\\s*\\=\\s*{(.*)}\\s*') # match key = { a = 1; b= 2}
rxp_openbrace = re.compile('^\\s*(\\w[\\w ]*\\w+)\\s*\\=?\\s*\\{\\s*')    # match xxx {
rxp_closebrace = re.compile('[^{]*}.*')               # match }
rxp_comment = re.compile('^\s*#.*')



#'dird', 'console', 'filed' or 'stored'
class Config(object):
    """Class for bacula configuration access"""
    
    def __init__(self, resource_type, filename=""):
        self.resource_type = resource_type
        self.filename = filename
        self.resources = resource.Resource(level=0)
        self.resources.name="<root>"

    def read(self):
        self.parse(self.resources,open(self.filename,"r"),0)
        #print self.resources
        
    def write(self):
        pass

    def getResourceById(self,theid):
        return self.resources.getById(theid)

    def getResourceByName(self,name):
        return self.resources.getByName(name)

    def getRoot(self):
        return self.resources

    def parse(self,curRes,f,level):
        #print "START",curRes.name

        while True:
            line=f.readline()
            if not line:
                break

            inlinecomment=None
         
            commentStart=line.find("#")
            if commentStart!=-1:
                inlinecomment=line[commentStart:]
                line=line[:commentStart].strip()
                #curRes.add_comment(inlinecomment)

            if rxp_closebrace.match(line):
                #print "closebraceline"
                break

            item2 = rxp_item2.match(line)
            if item2:
                #print "item2"
                name = item2.group(1)
                value = item2.group(2)
                #print "item:",name,value
                newRes=resource.Resource(level+1)
                newRes.name=name
                newRes.value="{"+value+"}"
                curRes.add_item(newRes)
                continue

            openbraceline = rxp_openbrace.match(line)
            if openbraceline:
                #print "openbraceline"
                resname = openbraceline.group(1)
                try:
                        resClass = getattr(resource,resname);
                except:
                        resClass = resource.Resource

                newRes=resClass(level+1)
                newRes.name=resname
                curRes.add_item(newRes);
                self.parse(newRes,f,level+1);

                continue

            item = rxp_item.match(line)
            if item:
                name = item.group(1)
                value = item.group(2)
                #print "item:",name,value
                newRes=resource.Resource(level+1)
                newRes.name=name
                newRes.value=value
                curRes.add_item(newRes)
                continue

        #print "END",curRes.name
    
class DirdConfig(Config):
    
    def __init__(self, filename=""):
        Config.__init__(self, 'dird', filename)
        
class ConsoleConfig(Config):
    pass

class FiledConfig(Config):
    pass

class StoredConfig(Config):
    pass

if __name__ == "__main__":
    
    dirdcfg = DirdConfig("test.conf")
    dirdcfg.read()
    #print dirdcfg.getResourceById(174)
    jobs=dirdcfg.getResourceByName("Job")
    for j in jobs:
        print j.getByName("Name")[0].value
    d=dirdcfg.getResourceByName("ip")[1]
    print d

    job=resource.Job(1,"Job")
    job.add("Name",'"test2"')
    job.add("Client",'"test2"')
    job.add("JobDefs",'"testdefs"')
    job.add("FileSet",'"Full Set"')

    root=dirdcfg.getRoot()
    root.add_item(job)

    print root
    sys.exit(0)
