/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.application.ViewHandlerProxy;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.NormalModeSerializer;
import com.icesoft.faces.context.PushModeSerializer;
import com.icesoft.faces.context.RequestStateManagerDelegate;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceLinker;
import com.icesoft.faces.context.ResourceRegistry;
import com.icesoft.faces.context.View;
import com.icesoft.faces.el.ELContextImpl;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.webapp.command.Reload;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.SessionExpiredException;
import com.icesoft.faces.webapp.http.portlet.PortletExternalContext;
import com.icesoft.faces.webapp.http.servlet.ServletExternalContext;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.util.SeamUtilities;
import com.sun.xml.fastinfoset.dom.DOMDocumentParser;
import com.sun.xml.fastinfoset.dom.DOMDocumentSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.fastinfoset.FastInfosetException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BridgeFacesContext
extends FacesContext
implements ResourceRegistry {
    private static final Log log = LogFactory.getLog((Class)BridgeFacesContext.class);
    private static final Pattern PageTemplatePattern = Pattern.compile(".*(\\.iface$|\\.jsf$|\\.faces$|\\.jsp$|\\.jspx$|\\.xhtml$|\\.seam$)");
    private static final Runnable Noop = new Runnable(){

        public void run() {
        }
    };
    private Application application;
    private BridgeExternalContext externalContext;
    private HashMap faceMessages = new HashMap();
    private Map bundles = Collections.EMPTY_MAP;
    private FacesMessage.Severity maxSeverity;
    private boolean renderResponse;
    private boolean responseComplete;
    private ResponseStream responseStream;
    private ResponseWriter responseWriter;
    private DOMSerializer domSerializer;
    private UIViewRoot viewRoot;
    private String sessionID;
    private String viewNumber;
    private View view;
    private Configuration configuration;
    private Collection jsCodeURIs = new ArrayList();
    private Collection cssRuleURIs = new ArrayList();
    private ResourceDispatcher resourceDispatcher;
    private String blockingRequestHandlerContext;
    private ELContext elContext;
    private DocumentStore documentStore;
    private String lastViewID;
    private boolean retainViewRoot;
    private Runnable onRelease = Noop;
    private Runnable clearViewRoot = new Runnable(){

        public void run() {
            BridgeFacesContext.this.onRelease = Noop;
            BridgeFacesContext.this.viewRoot = null;
        }
    };
    private static Constructor jsfUnitConstructor;
    private static String jsfUnitClass;
    RenderKit renderKit = null;
    String renderKitId = null;

    public BridgeFacesContext(Request request, final String viewIdentifier, String sessionID, final View view, final Configuration configuration, ResourceDispatcher resourceDispatcher, final SessionDispatcher.Monitor sessionMonitor, String blockingRequestHandlerContext, final Authorization authorization) throws Exception {
        BridgeFacesContext.setCurrentInstance((FacesContext)this);
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                BridgeFacesContext.this.externalContext = new ServletExternalContext(viewIdentifier, request, response, view, configuration, sessionMonitor, authorization, BridgeFacesContext.this);
            }

            public void portlet(Object request, Object response, Object portletConfig) {
                BridgeFacesContext.this.externalContext = new PortletExternalContext(viewIdentifier, request, response, view, configuration, sessionMonitor, portletConfig, authorization, BridgeFacesContext.this);
            }
        });
        String keepViewRoot = this.externalContext.getInitParameter("com.icesoft.faces.retainViewRoot");
        if (keepViewRoot != null) {
            this.retainViewRoot = Boolean.valueOf(keepViewRoot);
        }
        this.viewNumber = viewIdentifier;
        this.sessionID = sessionID;
        this.view = view;
        this.configuration = configuration;
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.resourceDispatcher = resourceDispatcher;
        this.blockingRequestHandlerContext = blockingRequestHandlerContext;
        this.documentStore = configuration.getAttributeAsBoolean("compressDOM", false) ? new FastInfosetDocumentStore() : new ReferenceDocumentStore();
        this.switchToNormalMode();
    }

    public void setCurrentInstance() {
        BridgeFacesContext.setCurrentInstance((FacesContext)this);
    }

    public static boolean isThreadLocalNull() {
        return BridgeFacesContext.getCurrentInstance() == null;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.faceMessages.keySet().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
    }

    public ELContext getELContext() {
        if (null != this.elContext) {
            return this.elContext;
        }
        this.elContext = new ELContextImpl(this.application);
        this.elContext.putContext(FacesContext.class, (Object)this);
        UIViewRoot root = this.getViewRoot();
        if (null != root) {
            this.elContext.setLocale(root.getLocale());
        }
        return this.elContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.maxSeverity;
    }

    public Iterator getMessages() {
        RequestStateManagerDelegate.clearMessages(this);
        ArrayList buffer = new ArrayList();
        if (this.faceMessages.values() == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator i = this.faceMessages.values().iterator();
        while (i.hasNext()) {
            buffer.addAll((Vector)i.next());
        }
        return buffer.iterator();
    }

    public Iterator getMessages(String clientId) {
        RequestStateManagerDelegate.clearMessages(this, clientId);
        Object obj = this.faceMessages.get(clientId);
        if (obj == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(clientId + " has no FacesMessages"));
            }
            return Collections.EMPTY_LIST.iterator();
        }
        return ((Vector)obj).iterator();
    }

    public RenderKit getRenderKit() {
        UIViewRoot viewRoot = this.getViewRoot();
        if (null == viewRoot) {
            return null;
        }
        String rootKitId = viewRoot.getRenderKitId();
        if (null == rootKitId) {
            return null;
        }
        if (!rootKitId.equals(this.renderKitId)) {
            this.renderKitId = rootKitId;
            RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            this.renderKit = renderKitFactory.getRenderKit((FacesContext)this, this.renderKitId);
        }
        return this.renderKit;
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public ResponseWriter createAndSetResponseWriter() throws IOException {
        this.responseWriter = new DOMResponseWriter(this, this.domSerializer, this.configuration, this.jsCodeURIs, this.cssRuleURIs, this.blockingRequestHandlerContext);
        return this.responseWriter;
    }

    public void switchToNormalMode() throws Exception {
        this.externalContext.switchToNormalMode();
        this.domSerializer = new SaveCurrentDocument(new NormalModeSerializer(this, this.externalContext.getWriter("UTF-8")));
    }

    public void switchToPushMode() throws Exception {
        this.bundles = this.externalContext.collectBundles();
        this.externalContext.switchToPushMode();
        this.domSerializer = new SaveCurrentDocument(new PushModeSerializer(this.documentStore, this.view, this, this.viewNumber));
    }

    public UIViewRoot getViewRoot() {
        if (this.externalContext.isSeamLifecycleShortcut()) {
            return null;
        }
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.viewRoot = viewRoot;
        if (viewRoot != null) {
            this.lastViewID = viewRoot.getViewId();
            String path = viewRoot.getViewId();
            if (null == path) {
                return;
            }
            if (PageTemplatePattern.matcher(path).matches()) {
                this.responseWriter = null;
            } else {
                this.view.put(new Reload(this.viewNumber));
                this.application.setViewHandler((ViewHandler)new SwitchViewHandler(this.application.getViewHandler(), path));
            }
        }
    }

    public String getIceFacesId() {
        return this.sessionID;
    }

    public String getViewNumber() {
        return this.viewNumber;
    }

    public String getFocusId() {
        Map map = this.externalContext.getRequestParameterMap();
        return map.containsKey("ice.focus") ? map.get("ice.focus") : "";
    }

    public void setFocusId(String focusId) {
        this.externalContext.getRequestParameterMap().put("ice.focus", focusId);
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (this.faceMessages.containsKey(clientId)) {
            ((Vector)this.faceMessages.get(clientId)).addElement(message);
        } else {
            Vector<FacesMessage> vector = new Vector<FacesMessage>();
            vector.add(message);
            this.faceMessages.put(clientId, vector);
        }
        if (this.maxSeverity == null || message.getSeverity().getOrdinal() > this.maxSeverity.getOrdinal()) {
            this.maxSeverity = message.getSeverity();
        }
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public void release() {
        if (this.doJSFUnitCheck()) {
            return;
        }
        this.faceMessages.clear();
        this.maxSeverity = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.renderKit = null;
        this.renderKitId = null;
        if (ImplementationUtil.isJSFStateSaving()) {
            this.viewRoot = null;
        }
        if (SeamUtilities.isSpring2Environment()) {
            if (!this.retainViewRoot) {
                this.viewRoot = null;
            }
        } else {
            this.externalContext.release();
        }
        this.onRelease.run();
        BridgeFacesContext.setCurrentInstance(null);
    }

    public void dispose() {
        this.externalContext.dispose();
    }

    public void applyBrowserDOMChanges() throws IOException {
        Document document = this.documentStore.load();
        if (document == null) {
            return;
        }
        Map parameters = this.externalContext.getRequestParameterValuesMap();
        NodeList formElements = document.getElementsByTagName("form");
        int formElementsLength = formElements.getLength();
        for (int i = 0; i < formElementsLength; ++i) {
            Element formElement = (Element)formElements.item(i);
            String id = formElement.getAttribute("id");
            if (!parameters.containsKey(id)) continue;
            this.applyBrowserFormChanges(parameters, document, formElement);
            break;
        }
        this.documentStore.cache(document);
    }

    protected void applyBrowserFormChanges(Map parameters, Document document, Element form) {
        String[] values;
        NodeList inputElements = form.getElementsByTagName("input");
        int inputElementsLength = inputElements.getLength();
        for (int i = 0; i < inputElementsLength; ++i) {
            Element inputElement = (Element)inputElements.item(i);
            String id = inputElement.getAttribute("id");
            if ("".equals(id)) continue;
            String name = null;
            if (parameters.containsKey(id)) {
                String value = ((String[])parameters.get(id))[0];
                if (!"".equals(value)) {
                    if (inputElement.hasAttribute("value")) {
                        inputElement.setAttribute("value", value);
                        continue;
                    }
                    if (!inputElement.getAttribute("type").equals("checkbox")) continue;
                    inputElement.setAttribute("checked", "checked");
                    continue;
                }
                inputElement.setAttribute("value", "");
                continue;
            }
            name = inputElement.getAttribute("name");
            if (!"".equals(name) && parameters.containsKey(name)) {
                String currValue;
                String type = inputElement.getAttribute("type");
                if ((type == null || !type.equals("checkbox")) && !type.equals("radio") || "".equals(currValue = inputElement.getAttribute("value"))) continue;
                boolean found = false;
                values = (String[])parameters.get(name);
                if (values != null) {
                    for (int v = 0; v < values.length; ++v) {
                        if (!currValue.equals(values[v])) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    if (type.equals("checkbox")) {
                        inputElement.setAttribute("checked", "true");
                        continue;
                    }
                    if (!type.equals("radio")) continue;
                    inputElement.setAttribute("checked", "checked");
                    continue;
                }
                inputElement.removeAttribute("checked");
                continue;
            }
            if (!inputElement.getAttribute("type").equals("checkbox")) continue;
            inputElement.removeAttribute("checked");
        }
        NodeList textareaElements = form.getElementsByTagName("textarea");
        int textareaElementsLength = textareaElements.getLength();
        for (int i = 0; i < textareaElementsLength; ++i) {
            Element textareaElement = (Element)textareaElements.item(i);
            String id = textareaElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            Node firstChild = textareaElement.getFirstChild();
            if (null != firstChild) {
                firstChild.setNodeValue(value);
                continue;
            }
            if (value == null || value.length() <= 0) continue;
            textareaElement.appendChild(document.createTextNode(value));
        }
        NodeList selectElements = form.getElementsByTagName("select");
        int selectElementsLength = selectElements.getLength();
        for (int i = 0; i < selectElementsLength; ++i) {
            Element selectElement = (Element)selectElements.item(i);
            String id = selectElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            values = Arrays.asList((String[])parameters.get(id));
            NodeList optionElements = selectElement.getElementsByTagName("option");
            int optionElementsLength = optionElements.getLength();
            for (int j = 0; j < optionElementsLength; ++j) {
                Element optionElement = (Element)optionElements.item(j);
                if (values.contains(optionElement.getAttribute("value"))) {
                    optionElement.setAttribute("selected", "selected");
                    continue;
                }
                optionElement.removeAttribute("selected");
            }
        }
    }

    public URI loadJavascriptCode(Resource resource) {
        String uri = this.resourceDispatcher.registerResource(resource).toString();
        if (!this.jsCodeURIs.contains(uri)) {
            this.jsCodeURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI loadJavascriptCode(Resource resource, ResourceLinker.Handler linkerHandler) {
        String uri = this.resourceDispatcher.registerResource(resource, linkerHandler).toString();
        if (!this.jsCodeURIs.contains(uri)) {
            this.jsCodeURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI loadCSSRules(Resource resource) {
        String uri = this.resourceDispatcher.registerResource(resource).toString();
        if (!this.cssRuleURIs.contains(uri)) {
            this.cssRuleURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI loadCSSRules(Resource resource, ResourceLinker.Handler linkerHandler) {
        String uri = this.resourceDispatcher.registerResource(resource, linkerHandler).toString();
        if (!this.cssRuleURIs.contains(uri)) {
            this.cssRuleURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI registerResource(Resource resource) {
        return this.registerResource(resource, null);
    }

    public URI registerResource(Resource resource, ResourceLinker.Handler linkerHandler) {
        try {
            return this.resolve(this.registerResourceWithRelativePath(resource, linkerHandler).toString());
        }
        catch (NullPointerException e) {
            log.warn((Object)"Cannot register a null resource");
            return null;
        }
    }

    public URI registerResourceWithRelativePath(Resource resource) {
        return this.registerResourceWithRelativePath(resource, null);
    }

    public URI registerResourceWithRelativePath(Resource resource, ResourceLinker.Handler linkerHandler) {
        return this.resourceDispatcher.registerResource(resource, linkerHandler);
    }

    public URI registerResource(final String mimeType, Resource resource) {
        return this.registerResource(new ProxyResource(resource){

            public void withOptions(Resource.Options options) throws IOException {
                options.setMimeType(mimeType);
            }
        });
    }

    public URI registerResource(final String mimeType, Resource resource, ResourceLinker.Handler linkerHandler) {
        return this.registerResource(new ProxyResource(resource){

            public void withOptions(Resource.Options options) throws IOException {
                options.setMimeType(mimeType);
            }
        }, linkerHandler);
    }

    public URI registerNamedResource(final String name, Resource resource) {
        return this.registerResource(new ProxyResource(resource){

            public void withOptions(Resource.Options options) throws IOException {
                options.setFileName(name);
            }
        });
    }

    public URI registerNamedResource(final String name, Resource resource, ResourceLinker.Handler linkerHandler) {
        return this.registerResource(new ProxyResource(resource){

            public void withOptions(Resource.Options options) throws IOException {
                options.setFileName(name);
            }
        }, linkerHandler);
    }

    private URI resolve(String uri) {
        return URI.create(this.application.getViewHandler().getResourceURL((FacesContext)this, uri));
    }

    public static FacesContext unwrap(FacesContext facesContext) {
        if (facesContext instanceof BridgeFacesContext) {
            return facesContext;
        }
        FacesContext result = facesContext;
        try {
            Method delegateMethod = facesContext.getClass().getDeclaredMethod("getDelegate", new Class[0]);
            delegateMethod.setAccessible(true);
            Object delegate = delegateMethod.invoke((Object)facesContext, (Object[])null);
            if (delegate instanceof BridgeFacesContext) {
                FacesMessage message;
                result = (FacesContext)delegate;
                Iterator clientIdIterator = facesContext.getClientIdsWithMessages();
                while (clientIdIterator.hasNext()) {
                    String clientId = (String)clientIdIterator.next();
                    Iterator facesMessagesForClientId = facesContext.getMessages(clientId);
                    while (facesMessagesForClientId.hasNext()) {
                        message = (FacesMessage)facesMessagesForClientId.next();
                        result.addMessage(clientId, message);
                    }
                }
                Iterator facesMessagesWithNoId = facesContext.getMessages(null);
                while (facesMessagesWithNoId.hasNext()) {
                    message = (FacesMessage)facesMessagesWithNoId.next();
                    result.addMessage("", message);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BridgeFacesContext delegate of " + facesContext));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void processPostback(Request request) throws Exception {
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                BridgeFacesContext.this.externalContext.update((HttpServletRequest)request, (HttpServletResponse)response);
                if (!ImplementationUtil.isJSFStateSaving()) {
                    BridgeFacesContext.this.externalContext.insertPostbackKey();
                }
            }

            public void portlet(Object request, Object response, Object config) {
            }
        });
    }

    public void reload(Request request) throws Exception {
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                BridgeFacesContext.this.externalContext.updateOnPageLoad(request, response);
            }

            public void portlet(Object request, Object response, Object config) {
                BridgeFacesContext.this.externalContext.updateOnPageLoad(request, response);
            }
        });
        this.externalContext.getRequestMap().put("javax.servlet.include.path_info", this.lastViewID);
    }

    public void injectBundles() {
        this.externalContext.injectBundles(this.bundles);
    }

    public boolean isContentIncluded() {
        Map requestMap = this.externalContext.getRequestMap();
        String frag = (String)requestMap.get("javax.servlet.include.request_uri");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.include.request_uri = " + frag));
        }
        if (frag != null) {
            return true;
        }
        frag = (String)requestMap.get("javax.servlet.include.servlet_path");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.include.servlet_path = " + frag));
        }
        if (frag != null) {
            return true;
        }
        frag = (String)requestMap.get("com.sun.faces.portlet.INIT");
        return frag != null;
    }

    void resetLastViewID() {
        this.lastViewID = null;
        if (!ImplementationUtil.isJSFStateSaving()) {
            this.onRelease = this.clearViewRoot;
        }
    }

    private boolean doJSFUnitCheck() {
        try {
            if (jsfUnitConstructor != null) {
                this.externalContext.getSessionMap().put(jsfUnitClass + ".sessionkey", jsfUnitConstructor.newInstance(this));
                return true;
            }
        }
        catch (SessionExpiredException ite) {
        }
        catch (Exception e) {
            log.error((Object)"Exception instantiating JSFUnitFacesContext", (Throwable)e);
        }
        return false;
    }

    static {
        try {
            Class<?> c = Class.forName("org.jboss.jsfunit.context.JSFUnitFacesContext");
            jsfUnitClass = c.getName();
            jsfUnitConstructor = c.getConstructor(FacesContext.class);
            log.info((Object)"JSFUnit environment detected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class SaveCurrentDocument
    implements DOMSerializer {
        private final DOMSerializer serializer;

        public SaveCurrentDocument(DOMSerializer serializer) {
            this.serializer = serializer;
        }

        public void serialize(Document document) throws IOException {
            this.serializer.serialize(document);
            BridgeFacesContext.this.documentStore.save(document);
        }
    }

    private static class FastInfosetDocumentStore
    implements DocumentStore {
        private byte[] data = new byte[0];
        private Document document = null;

        private FastInfosetDocumentStore() {
        }

        public void save(Document document) throws IOException {
            DOMDocumentSerializer serializer = new DOMDocumentSerializer();
            ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
            serializer.setOutputStream((OutputStream)out);
            serializer.serialize(document);
            this.data = out.toByteArray();
            this.document = null;
        }

        public void cache(Document document) {
            this.document = document;
        }

        public Document load() throws IOException {
            if (null != this.document) {
                return this.document;
            }
            if (this.data.length == 0) {
                return null;
            }
            Document document = DOMResponseWriter.DOCUMENT_BUILDER.newDocument();
            try {
                DOMDocumentParser parser = new DOMDocumentParser();
                ByteArrayInputStream in = new ByteArrayInputStream(this.data);
                parser.parse(document, (InputStream)in);
            }
            catch (FastInfosetException e) {
                throw new IOException(e.getMessage());
            }
            return document;
        }
    }

    private static class ReferenceDocumentStore
    implements DocumentStore {
        private Document document;

        private ReferenceDocumentStore() {
        }

        public void save(Document document) {
            this.document = document;
        }

        public void cache(Document document) {
            this.document = document;
        }

        public Document load() {
            return this.document;
        }
    }

    public static interface DocumentStore {
        public void save(Document var1) throws IOException;

        public void cache(Document var1) throws IOException;

        public Document load() throws IOException;
    }

    private static class ProxyResource
    implements Resource {
        private final Resource resource;

        public ProxyResource(Resource resource) {
            this.resource = resource;
        }

        public String calculateDigest() {
            return this.resource.calculateDigest();
        }

        public InputStream open() throws IOException {
            return this.resource.open();
        }

        public Date lastModified() {
            return this.resource.lastModified();
        }

        public void withOptions(Resource.Options options) throws IOException {
            this.resource.withOptions(options);
        }
    }

    private class SwitchViewHandler
    extends ViewHandlerProxy {
        private final String path;

        public SwitchViewHandler(ViewHandler originalHandler, String path) {
            super(originalHandler);
            this.path = path;
        }

        public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
            BridgeFacesContext.this.application.setViewHandler((ViewHandler)new DispatchingViewHandler(this.handler, this.path));
            this.handler.renderView(context, viewToRender);
        }
    }

    private class DispatchingViewHandler
    extends ViewHandlerProxy {
        private final String path;

        public DispatchingViewHandler(ViewHandler originalHandler, String path) {
            super(originalHandler);
            this.path = path;
        }

        public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
            BridgeFacesContext.this.application.setViewHandler(this.handler);
            BridgeFacesContext.this.externalContext.dispatch(this.path);
        }
    }
}

