/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.RenderHub;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.webapp.xmlhttp.FatalRenderingException;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.icesoft.faces.webapp.xmlhttp.TransientRenderingException;
import com.icesoft.util.SeamUtilities;
import com.icesoft.util.StaticTimerUtility;
import com.icesoft.util.ThreadLocalUtility;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RunnableRender
implements Runnable {
    private static Log log = LogFactory.getLog((Class)RenderHub.class);
    private Renderable renderable;

    public RunnableRender(Renderable renderable) {
        this.renderable = renderable;
    }

    public Renderable getRenderable() {
        return this.renderable;
    }

    public void run() {
        block13: {
            if (this.renderable == null) {
                return;
            }
            PersistentFacesState state = this.renderable.getState();
            if (state == null) {
                String msg = "unable to render, PersistentFacesState is null";
                if (log.isWarnEnabled()) {
                    log.warn((Object)msg);
                }
                this.renderable.renderingException(new TransientRenderingException(msg));
                return;
            }
            state.setCurrentInstance();
            state.installContextClassLoader();
            try {
                if (SeamUtilities.isSeamEnvironment()) {
                    this.testSession(state);
                }
                if (StaticTimerUtility.Log.isTraceEnabled()) {
                    StaticTimerUtility.startSubjobTimer();
                }
                state.executeAndRender();
                if (StaticTimerUtility.Log.isTraceEnabled()) {
                    StaticTimerUtility.subJobTimerComplete();
                }
            }
            catch (IllegalStateException ise) {
                this.renderable.renderingException(new TransientRenderingException(ise));
            }
            catch (RenderingException ex) {
                this.renderable.renderingException(ex);
                if (ex instanceof TransientRenderingException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"transient render exception", (Throwable)ex);
                    }
                }
                if (ex instanceof FatalRenderingException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"fatal render exception", (Throwable)ex);
                    }
                }
                if (!log.isErrorEnabled()) break block13;
                log.error((Object)"unknown render exception", (Throwable)ex);
            }
        }
        ThreadLocalUtility.checkThreadLocals(1);
    }

    private void testSession(PersistentFacesState state) throws IllegalStateException {
        FacesContext fc = state.getFacesContext();
        Object o = fc.getExternalContext().getSession(false);
        if (o == null) {
            this.renderable.renderingException(new FatalRenderingException("Session has ended (User Logout?)"));
        } else if (o instanceof HttpSession) {
            HttpSession session = (HttpSession)o;
            session.getAttributeNames();
        } else if (o instanceof PortletSession) {
            PortletSession ps = (PortletSession)o;
            ps.getAttributeNames();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RunnableRender) || this.renderable == null) {
            return false;
        }
        Renderable comparedRenderable = ((RunnableRender)obj).getRenderable();
        if (comparedRenderable == null) {
            return false;
        }
        PersistentFacesState comparedState = comparedRenderable.getState();
        if (comparedState == null) {
            return false;
        }
        PersistentFacesState myState = this.renderable.getState();
        if (myState == null) {
            return false;
        }
        return myState.equals(comparedState);
    }
}

