/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language.antlr;

import antlr.ANTLRHashString;
import antlr.CharBuffer;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamIOException;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.JavaParser;
import de.hunsicker.jalopy.language.JavadocLexer;
import de.hunsicker.jalopy.language.Lexer;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.InternalJavaLexer;
import de.hunsicker.jalopy.language.antlr.JavadocParser;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.util.StringHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class JavaLexer
extends InternalJavaLexer
implements Lexer {
    public static final int JDK_1_3 = 13;
    public static final int JDK_1_4 = 14;
    private static final String SPACE = " ";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";
    private FileFormat _fileFormat = FileFormat.UNKNOWN;
    private String _lineSeparator = System.getProperty("line.separator");
    private Recognizer _recognizer;
    private Logger _logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
    public boolean parseJavadocComments;
    public int sourceVersion = 14;
    public boolean removeJavadocComments;
    public boolean formatMLComments;
    public boolean removeSLComments;
    public boolean removeMLComments;
    private JavaParser _parser;
    private JavadocParser _javadocParser;
    private CompositeFactory _factory = null;

    public JavaLexer(Reader in, CompositeFactory factory) {
        this(new CharBuffer(in), factory);
    }

    public JavaLexer(InputBuffer ib, CompositeFactory factory) {
        this(new MyLexerSharedInputState(ib), factory);
    }

    public JavaLexer(LexerSharedInputState state, CompositeFactory factory) {
        super(state);
        this._factory = factory;
    }

    public JavaLexer(CompositeFactory factory) {
        this(new StringReader(EMPTY_STRING), factory);
        JavadocLexer lexer = new JavadocLexer(factory);
        this._javadocParser = (JavadocParser)lexer.getParser();
        this._recognizer = new Recognizer(this._javadocParser, lexer);
        this._javadocParser.setRecognizer(this._recognizer);
        factory.setJavadocRecognizer(this._recognizer);
        this._parser = new JavaParser(this);
        this._parser.setASTFactory(factory.getJavaNodeFactory());
    }

    public JavadocParser getJavadocParser() {
        return this._javadocParser;
    }

    public Parser getParser() {
        return this._parser;
    }

    public void setRemoveMLComments(boolean remove) {
        this.removeMLComments = remove;
    }

    public void setFormatMLComments(boolean format) {
        this.formatMLComments = format;
    }

    public boolean isFormatMLComments() {
        return this.formatMLComments;
    }

    public boolean isRemoveMLComments() {
        return this.removeMLComments;
    }

    public void setRemoveSLComments(boolean remove) {
        this.removeSLComments = remove;
    }

    public boolean isRemoveSLComments() {
        return this.removeSLComments;
    }

    public void setRemoveJavadocComments(boolean remove) {
        this.removeJavadocComments = remove;
    }

    public boolean isRemoveJavadocComments() {
        return this.removeJavadocComments;
    }

    public void setParseJavadocComments(boolean parse) {
        this.parseJavadocComments = parse;
    }

    public boolean isParseJavadocComments() {
        return this.parseJavadocComments;
    }

    public void setCompatibility(int version) {
        this.sourceVersion = version;
    }

    public int getCompatibility() {
        return this.sourceVersion;
    }

    public int testLiteralsTable(int ttype) {
        this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
        Integer literalsIndex = (Integer)this.literals.get(this.hashString);
        if (literalsIndex != null) {
            ttype = literalsIndex;
            switch (ttype) {
                case 130: {
                    switch (this.sourceVersion) {
                        case 13: {
                            ttype = 79;
                        }
                    }
                }
            }
        }
        return ttype;
    }

    public int testLiteralsTable(String tokenText, int ttype) {
        ANTLRHashString s = new ANTLRHashString(tokenText, this);
        Integer literalsIndex = (Integer)this.literals.get(s);
        if (literalsIndex != null) {
            ttype = literalsIndex;
            switch (ttype) {
                case 130: {
                    switch (this.sourceVersion) {
                        case 13: {
                            ttype = 79;
                        }
                    }
                }
            }
        }
        return ttype;
    }

    public void panic() {
        if (this.inputState != null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), "JavaLexer: panic"};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        } else {
            if (this._logger == null) {
                this._logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
            }
            Object[] args = new Object[]{"???", new Integer(0), new Integer(0), "JavaLexer: panic"};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        }
    }

    public void panic(String message) {
        if (this.inputState != null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        } else {
            if (this._logger == null) {
                this._logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
            }
            Object[] args = new Object[]{"???", new Integer(0), new Integer(0), message};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        }
    }

    public void reportError(RecognitionException ex) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), ex.getMessage()};
        this._logger.l7dlog((Priority)Level.ERROR, "PARSER_ERROR", args, (Throwable)ex);
    }

    public void reportError(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
        this._logger.l7dlog((Priority)Level.ERROR, "PARSER_ERROR", args, null);
    }

    public void reportWarning(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
        this._logger.l7dlog((Priority)Level.WARN, "PARSER_ERROR", args, null);
    }

    protected Token makeToken(int t) {
        ExtendedToken newToken = this._factory.getExtendedTokenFactory().create(t, null);
        ((MyLexerSharedInputState)this.inputState).configureToken(newToken);
        newToken.endLine = this.getLine();
        newToken.endColumn = this.getColumn();
        return newToken;
    }

    public void setTokenObjectClass(String clazz) {
        if (clazz.equals("antlr.CommonToken")) {
            clazz = "de.hunsicker.jalopy.language.antlr.ExtendedToken";
        }
        super.setTokenObjectClass(clazz);
    }

    public FileFormat getFileFormat() {
        return this._fileFormat;
    }

    public void setInputBuffer(InputBuffer buf) {
        if (this.inputState != null) {
            ((MyLexerSharedInputState)this.inputState).setInputBuffer(buf);
        }
    }

    public void setInputBuffer(Reader in) {
        this.setInputBuffer(new CharBuffer(in));
    }

    public void reset() {
        if (this.inputState != null) {
            this.inputState.reset();
        }
        this.setFilename("<unknown>");
    }

    private void getNextSeparator(SeparatorInfo result, String str) {
        int offset = str.indexOf("\r\n");
        if (offset > -1) {
            result.offset = offset;
            result.length = 2;
        } else {
            result.length = 1;
            offset = str.indexOf(10);
            result.offset = offset > -1 ? offset : (offset = str.indexOf(13));
        }
    }

    private String removeLeadingWhitespace(String comment, int column, String lineSeparator) {
        String[] lines = this.split(comment, column);
        StringBuffer buf = new StringBuffer(comment.length());
        int i = 0;
        int size = lines.length;
        while (i < size) {
            buf.append(lines[i]);
            buf.append(this._lineSeparator);
            ++i;
        }
        buf.setLength(buf.length() - this._lineSeparator.length());
        return buf.toString();
    }

    protected Token makeJavaDoc(Token node, String newText) throws TokenStreamIOException {
        node.setText(newText);
        boolean javadoc = node.getText().trim().startsWith("/**");
        if (javadoc) {
            if (!this.removeJavadocComments) {
                if (this.parseJavadocComments) {
                    String t = node.getText();
                    if (t.indexOf(9) > -1) {
                        t = StringHelper.replace(t, "\t", StringHelper.repeat(SPACE, this.getTabSize()));
                    }
                    node.setText(t);
                    Node comment = (Node)this._factory.getJavaNodeFactory().create(6);
                    comment.setText(t);
                    node = this._factory.getExtendedTokenFactory().create(6, t);
                    ((ExtendedToken)node).comment = comment;
                } else {
                    String t = node.getText();
                    if (t.indexOf(9) > -1) {
                        t = StringHelper.replace(t, "\t", StringHelper.repeat(SPACE, this.getTabSize()));
                    }
                    t = this.removeLeadingWhitespace(t, node.getColumn() - 1, this._lineSeparator);
                    node.setText(t);
                    node.setType(6);
                }
            } else {
                node.setType(-1);
            }
        } else if (!this.removeMLComments) {
            String t = node.getText();
            if (t.indexOf(9) > -1) {
                t = StringHelper.replace(t, "\t", StringHelper.repeat(SPACE, this.getTabSize()));
            }
            if (!this.formatMLComments) {
                t = this.removeLeadingWhitespace(t, node.getColumn() - 1, this._lineSeparator);
            }
            node.setText(t);
        } else {
            node.setType(-1);
        }
        return node;
    }

    private String[] split(String str, int beginOffset) {
        ArrayList<String> lines = new ArrayList<String>(15);
        SeparatorInfo info = new SeparatorInfo();
        this.getNextSeparator(info, str);
        while (info.offset > -1) {
            String line = str.substring(0, info.offset);
            str = str.substring(info.offset + info.length);
            int charOffset = StringHelper.indexOfNonWhitespace(line);
            line = charOffset > beginOffset ? line.substring(beginOffset) : (charOffset > -1 ? line.substring(charOffset) : EMPTY_STRING);
            lines.add(line);
            this.getNextSeparator(info, str);
        }
        int charOffset = StringHelper.indexOfNonWhitespace(str);
        str = charOffset > beginOffset ? str.substring(beginOffset) : (charOffset > -1 ? str.substring(charOffset) : EMPTY_STRING);
        lines.add(str);
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private static final class SeparatorInfo {
        int length = 1;
        int offset = -1;

        private SeparatorInfo() {
        }
    }

    static class MyLexerSharedInputState
    extends LexerSharedInputState {
        public MyLexerSharedInputState(InputBuffer inbuf) {
            super(inbuf);
        }

        public MyLexerSharedInputState() {
            this((InputBuffer)null);
        }

        public void setInputBuffer(InputBuffer inbuf) {
            this.reset();
            this.input = inbuf;
        }

        public void configureToken(ExtendedToken tok) {
            tok.setColumn(this.tokenStartColumn);
            tok.setLine(this.tokenStartLine);
        }
    }
}

