/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing.syntax;

import de.hunsicker.jalopy.swing.syntax.Token;
import javax.swing.text.Segment;

public abstract class TokenMarker {
    protected Token firstToken;
    protected Token lastToken;
    protected LineInfo[] lineInfo;
    protected boolean nextLineRequested;
    protected int length;

    protected TokenMarker() {
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    public void deleteLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        int len = index + lines;
        this.length -= lines;
        System.arraycopy(this.lineInfo, len, this.lineInfo, index, this.lineInfo.length - len);
    }

    public void insertLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        this.length += lines;
        this.ensureCapacity(this.length);
        int len = index + lines;
        System.arraycopy(this.lineInfo, index, this.lineInfo, len, this.lineInfo.length - len);
        int i = index + lines - 1;
        while (i >= index) {
            this.lineInfo[i] = new LineInfo();
            --i;
        }
    }

    public Token markTokens(Segment line, int lineIndex) {
        byte token;
        this.lastToken = null;
        LineInfo info = this.lineInfo[lineIndex];
        byte oldToken = info.token;
        info.token = token = this.markTokensImpl(lineIndex == 0 ? (byte)0 : this.lineInfo[lineIndex - 1].token, line, lineIndex);
        this.nextLineRequested = oldToken != token;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    protected abstract byte markTokensImpl(byte var1, Segment var2, int var3);

    protected void addToken(int length, byte id) {
        if (id >= 100 && id <= 126) {
            throw new InternalError("Invalid id: " + id);
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new Token(length, id);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = length;
            this.firstToken.id = id;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new Token(length, id);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = length;
            this.lastToken.id = id;
        }
    }

    protected void ensureCapacity(int index) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[index + 1];
        } else if (this.lineInfo.length <= index) {
            LineInfo[] lineInfoN = new LineInfo[(index + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoN, 0, this.lineInfo.length);
            this.lineInfo = lineInfoN;
        }
    }

    public static final class LineInfo {
        public Object obj;
        public byte token;

        public LineInfo() {
        }

        public LineInfo(byte token, Object obj) {
            this.token = token;
            this.obj = obj;
        }
    }
}

