/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.ModifierType;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

final class ModifiersPrinter
extends AbstractPrinter {
    private static final Comparator COMP_MODIFIERS = new ModifiersComparator();
    private static final Printer INSTANCE = new ModifiersPrinter();

    protected ModifiersPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        block8: {
            block7: {
                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.SORT_MODIFIERS, false)) break block7;
                JavaNode firstModifier = (JavaNode)node.getFirstChild();
                if (firstModifier == null) break block8;
                CommonHiddenStreamToken firstComment = firstModifier.getHiddenBefore();
                firstModifier.setHiddenBefore(null);
                ArrayList<JavaNode> modifiers = new ArrayList<JavaNode>(5);
                AST modifier = firstModifier;
                while (modifier != null) {
                    if (modifier.getType() == 56) {
                        if (firstComment != null) {
                            modifier.setHiddenBefore(firstComment);
                            firstComment = null;
                        }
                        PrinterFactory.create(modifier, out).print(modifier, out);
                    } else {
                        modifiers.add((JavaNode)modifier);
                    }
                    modifier = modifier.getNextSibling();
                }
                Collections.sort(modifiers, COMP_MODIFIERS);
                if (!modifiers.isEmpty()) {
                    firstModifier = (JavaNode)modifiers.get(0);
                    firstModifier.setHiddenBefore(firstComment);
                }
                int i = 0;
                int size = modifiers.size();
                while (i < size) {
                    AST modifier2 = (AST)modifiers.get(i);
                    PrinterFactory.create(modifier2, out).print(modifier2, out);
                    ++i;
                }
                break block8;
            }
            AST modifier = node.getFirstChild();
            while (modifier != null) {
                PrinterFactory.create(modifier, out).print(modifier, out);
                modifier = modifier.getNextSibling();
            }
        }
    }

    private static final class ModifiersComparator
    implements Comparator {
        private ModifiersComparator() {
        }

        public int compare(Object o1, Object o2) {
            AST node1 = (AST)o1;
            AST node2 = (AST)o2;
            ModifierType modifier1 = ModifierType.valueOf(node1.getText());
            ModifierType modifier2 = ModifierType.valueOf(node2.getText());
            return modifier1.compareTo(modifier2);
        }

        public boolean equals(Object o) {
            return o instanceof ModifiersComparator;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

