/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.xpointer;

import java.util.Hashtable;
import org.apache.woden.types.NCName;
import org.apache.woden.types.XMLChar;
import org.apache.woden.xpointer.ElementPointerPart;
import org.apache.woden.xpointer.InvalidXPointerException;
import org.apache.woden.xpointer.XPointer;

final class XPointerParser {
    private static final String emptyString = "".intern();

    XPointerParser() {
    }

    public static void parseXPointer(String xpointerString, XPointer xpointer) throws InvalidXPointerException {
        String ELEMENT_SCHEME_NAME = "element";
        Tokens tokens = new Tokens();
        int length = xpointerString.length();
        boolean success = Scanner.scanExpr(tokens, xpointerString, 0, length);
        if (!success) {
            throw new InvalidXPointerException("Invalid XPointer expression", xpointerString);
        }
        block4: while (tokens.hasMore()) {
            int token = tokens.nextToken();
            switch (token) {
                case 2: {
                    token = tokens.nextToken();
                    String shortHandPointerName = tokens.getTokenString(token);
                    if (shortHandPointerName == null) {
                        throw new InvalidXPointerException("Invalid Shorthand XPointer", xpointerString);
                    }
                    xpointer.setShorthandPointer(new NCName(shortHandPointerName));
                    continue block4;
                }
                case 3: {
                    token = tokens.nextToken();
                    String prefix = tokens.getTokenString(token);
                    token = tokens.nextToken();
                    String localName = tokens.getTokenString(token);
                    String schemeName = prefix + localName;
                    int openParenCount = 0;
                    int closeParenCount = 0;
                    token = tokens.nextToken();
                    String openParen = tokens.getTokenString(token);
                    if (openParen != "XPTRTOKEN_OPEN_PAREN") {
                        if (token == 2) {
                            throw new InvalidXPointerException("MultipleShortHandPointers", xpointerString);
                        }
                        throw new InvalidXPointerException("Invalid XPointer Expression", xpointerString);
                    }
                    ++openParenCount;
                    String schemeData = null;
                    while (tokens.hasMore() && (schemeData = tokens.getTokenString(token = tokens.nextToken())) == "XPTRTOKEN_OPEN_PAREN") {
                        ++openParenCount;
                    }
                    token = tokens.nextToken();
                    schemeData = tokens.getTokenString(token);
                    if (tokens.hasMore()) {
                        token = tokens.nextToken();
                        String closeParen = tokens.getTokenString(token);
                        if (closeParen != "XPTRTOKEN_CLOSE_PAREN") {
                            new InvalidXPointerException("SchemeDataNotFollowedByCloseParenthesis", xpointerString);
                        }
                    } else {
                        new InvalidXPointerException("SchemeDataNotFollowedByCloseParenthesis", xpointerString);
                    }
                    ++closeParenCount;
                    while (tokens.hasMore() && tokens.getTokenString(tokens.peekToken()) == "XPTRTOKEN_OPEN_PAREN") {
                        ++closeParenCount;
                    }
                    if (openParenCount != closeParenCount) {
                        throw new InvalidXPointerException("UnbalancedParenthesisInXPointerExpression", xpointerString);
                    }
                    if (!schemeName.equals("element")) continue block4;
                    ElementPointerPart elementSchemePointer = ElementPointerPart.parseFromString(schemeData);
                    xpointer.addPointerPart(elementSchemePointer);
                    continue block4;
                }
            }
            throw new InvalidXPointerException("InvalidXPointerExpression", xpointerString);
        }
    }

    private static class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_CARRET = 3;
        private static final byte CHARTYPE_OPEN_PAREN = 4;
        private static final byte CHARTYPE_CLOSE_PAREN = 5;
        private static final byte CHARTYPE_MINUS = 6;
        private static final byte CHARTYPE_PERIOD = 7;
        private static final byte CHARTYPE_SLASH = 8;
        private static final byte CHARTYPE_DIGIT = 9;
        private static final byte CHARTYPE_COLON = 10;
        private static final byte CHARTYPE_EQUAL = 11;
        private static final byte CHARTYPE_LETTER = 12;
        private static final byte CHARTYPE_UNDERSCORE = 13;
        private static final byte CHARTYPE_NONASCII = 14;
        private static final byte[] fASCIICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 1, 1, 1, 1, 4, 5, 1, 1, 1, 6, 7, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 1, 1, 11, 1, 1, 1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 3, 13, 1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 1, 1};

        private Scanner() {
        }

        private static boolean scanExpr(Tokens tokens, String data, int currentOffset, int endOffset) throws InvalidXPointerException {
            int openParen = 0;
            int closeParen = 0;
            boolean isQName = false;
            String name = null;
            String prefix = null;
            String schemeData = null;
            StringBuffer schemeDataBuff = new StringBuffer();
            while (currentOffset != endOffset) {
                int ch = data.charAt(currentOffset);
                while ((ch == 32 || ch == 10 || ch == 9 || ch == 13) && ++currentOffset != endOffset) {
                    ch = data.charAt(currentOffset);
                }
                if (currentOffset == endOffset) break;
                int chartype = ch >= 128 ? 14 : fASCIICharMap[ch];
                switch (chartype) {
                    case 4: {
                        Scanner.addToken(tokens, 0);
                        ++openParen;
                        ++currentOffset;
                        break;
                    }
                    case 5: {
                        Scanner.addToken(tokens, 1);
                        ++closeParen;
                        ++currentOffset;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        if (openParen == 0) {
                            int nameOffset = currentOffset;
                            if ((currentOffset = Scanner.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                                throw new InvalidXPointerException("InvalidShortHandPointer", data);
                            }
                            ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                            name = data.substring(nameOffset, currentOffset).intern();
                            prefix = emptyString;
                            if (ch == 58) {
                                if (++currentOffset == endOffset) {
                                    return false;
                                }
                                ch = data.charAt(currentOffset);
                                prefix = name;
                                nameOffset = currentOffset;
                                if ((currentOffset = Scanner.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                                    return false;
                                }
                                ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                                isQName = true;
                                name = data.substring(nameOffset, currentOffset).intern();
                            }
                            if (currentOffset != endOffset) {
                                Scanner.addToken(tokens, 3);
                                tokens.addToken(prefix);
                                tokens.addToken(name);
                                isQName = false;
                            } else if (currentOffset == endOffset) {
                                Scanner.addToken(tokens, 2);
                                tokens.addToken(name);
                                isQName = false;
                            }
                            closeParen = 0;
                            break;
                        }
                        if (openParen > 0 && closeParen == 0 && name != null) {
                            int dataOffset = currentOffset;
                            if ((currentOffset = Scanner.scanData(data, schemeDataBuff, endOffset, currentOffset)) == dataOffset) {
                                throw new InvalidXPointerException("InvalidSchemeDataInXPointer", data);
                            }
                            ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                            schemeData = schemeDataBuff.toString().intern();
                            Scanner.addToken(tokens, 4);
                            tokens.addToken(schemeData);
                            openParen = 0;
                            schemeDataBuff.delete(0, schemeDataBuff.length());
                            break;
                        }
                        return false;
                    }
                }
            }
            return true;
        }

        private static int scanNCName(String data, int endOffset, int currentOffset) {
            byte chartype;
            char ch = data.charAt(currentOffset);
            if (ch >= '\u0080' ? !XMLChar.isNameStart(ch) : (chartype = fASCIICharMap[ch]) != 12 && chartype != 13) {
                return currentOffset;
            }
            while (++currentOffset < endOffset && !((ch = data.charAt(currentOffset)) >= '\u0080' ? !XMLChar.isName(ch) : (chartype = fASCIICharMap[ch]) != 12 && chartype != 9 && chartype != 7 && chartype != 6 && chartype != 13)) {
            }
            return currentOffset;
        }

        private static int scanData(String data, StringBuffer schemeData, int endOffset, int currentOffset) {
            while (currentOffset != endOffset) {
                int chartype;
                char ch = data.charAt(currentOffset);
                int n = chartype = ch >= '\u0080' ? 14 : fASCIICharMap[ch];
                if (chartype == 4) {
                    schemeData.append((int)ch);
                    ++currentOffset;
                    currentOffset = Scanner.scanData(data, schemeData, endOffset, currentOffset);
                    if (currentOffset == endOffset) {
                        return currentOffset;
                    }
                    ch = data.charAt(currentOffset);
                    int n2 = chartype = ch >= '\u0080' ? 14 : fASCIICharMap[ch];
                    if (chartype != 5) {
                        return endOffset;
                    }
                    schemeData.append(ch);
                    ++currentOffset;
                    continue;
                }
                if (chartype == 5) {
                    return currentOffset;
                }
                if (chartype == 3) {
                    int n3 = chartype = (ch = data.charAt(++currentOffset)) >= '\u0080' ? 14 : fASCIICharMap[ch];
                    if (chartype != 3 && chartype != 4 && chartype != 5) break;
                    schemeData.append(ch);
                    ++currentOffset;
                    continue;
                }
                schemeData.append(ch);
                ++currentOffset;
            }
            return currentOffset;
        }

        protected static void addToken(Tokens tokens, int token) {
            if (token == 0 || token == 1 || token == 3 || token == 4 || token == 2) {
                tokens.addToken(token);
                return;
            }
            throw new IllegalArgumentException("InvalidXPointerToken");
        }
    }

    private static class Tokens {
        private static final int XPTRTOKEN_OPEN_PAREN = 0;
        private static final int XPTRTOKEN_CLOSE_PAREN = 1;
        private static final int XPTRTOKEN_SHORTHAND = 2;
        private static final int XPTRTOKEN_SCHEMENAME = 3;
        private static final int XPTRTOKEN_SCHEMEDATA = 4;
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private int fCurrentTokenIndex;
        private Hashtable fTokenNames = new Hashtable();

        private Tokens() {
            this.fTokenNames.put(new Integer(0), "XPTRTOKEN_OPEN_PAREN");
            this.fTokenNames.put(new Integer(1), "XPTRTOKEN_CLOSE_PAREN");
            this.fTokenNames.put(new Integer(2), "XPTRTOKEN_SHORTHAND");
            this.fTokenNames.put(new Integer(3), "XPTRTOKEN_SCHEMENAME");
            this.fTokenNames.put(new Integer(4), "XPTRTOKEN_SCHEMEDATA");
        }

        private String getTokenString(int token) {
            return (String)this.fTokenNames.get(new Integer(token));
        }

        private void addToken(String tokenStr) {
            Integer tokenInt = (Integer)this.fTokenNames.get(tokenStr);
            if (tokenInt == null) {
                tokenInt = new Integer(this.fTokenNames.size());
                this.fTokenNames.put(tokenInt, tokenStr);
            }
            this.addToken(tokenInt);
        }

        private void addToken(int token) {
            try {
                this.fTokens[this.fTokenCount] = token;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int[] oldList = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(oldList, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = token;
            }
            ++this.fTokenCount;
        }

        private boolean hasMore() {
            return this.fCurrentTokenIndex < this.fTokenCount;
        }

        private int nextToken() {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                throw new IndexOutOfBoundsException("There are no more tokens to return.");
            }
            return this.fTokens[this.fCurrentTokenIndex++];
        }

        private int peekToken() {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                throw new IndexOutOfBoundsException("There are no more tokens to return.");
            }
            return this.fTokens[this.fCurrentTokenIndex];
        }
    }
}

