#!/bin/bash 
# build script
#
# $Id: dassbuild.sh 809 2009-12-14 17:04:47Z joergs $
#
# builds RPM in an clean chroot build environment.
# uses the Suse build script.
#
# without parameter, it checks the directory for the files
# SOURCES or SPECSOURCES. 
# The files definied in there are copied to the 
# build system.
# 
# when used with parameter, 
# this parameter is expected to be a source rpm
#
# config file:
# /etc/dassbuild.conf
# lists the sources for the different distributions
#
# the rest is controlled by environment variables
#
# dassbuild.sh uses sudo. /etc/sudoers needs a line like:
# %users  ALL=(ALL)       NOPASSWD: /usr/bin/dassbuild_wrapper.sh
# for automatic building (create a symlink or copy the file,
# see also the Variable BUILDSCRIPT and content of this script)
#
# return codes:
# 0: success
# 1: skipped (current RPM already in dest dir)
# >1: error
#
# RPM releases are set 
# to the svn version number of the project directory.
# Modifiers are:
#   m: release + local modifications
#   p: release + submited modifications. svn update project directory is needed 


# set LANG to default (english)
# required for SVN
export LC_ALL=C

CONFIG_FILE=/etc/dassbuild/dassbuild.conf
BUILDSCRIPT=/usr/bin/dassbuild_wrapper.sh
BUILD_CMD=/usr/bin/build

#
# setting build variables
#
BUILDUSER=$USER
[ -z $DEST_DIR ] && DEST_DIR="/tmp/build.$BUILDUSER"
BUILDTEMP=$DEST_DIR/buildsrc/

[ -z "$BUILD_USES_SVN" ] && BUILD_USES_SVN="yes"
[ -z "$BUILD_MODE" ] && BUILD_MODE="--clean"
[ -z "$BUILD_DIST" ] && export BUILD_DIST="sles9-i386"
[ -z "$BUILD_ROOT" ] && BUILD_ROOT="/var/tmp/buildsystem.$BUILDUSER.$BUILD_DIST"
[ -z "$BUILD_PREPARE_SPEC" ] && BUILD_PREPARE_SPEC="no"

BUILDVARS=$BUILDTEMP/build.vars

#
# create source archive file
#
dassbuild_prepare.sh $*
RT=$?
if [ $RT -eq 1 ]; then
    echo "nothing more to do"
    exit 0
elif [ $RT -gt 1 ]; then
    echo "error: failed to prepare sources"
    exit 1
fi



if [ -r $CONFIG_FILE ]; then
	source $CONFIG_FILE
    MOD_BUILD_DIST=`sed "s/[-+.]/_/g" <<< $BUILD_DIST`
    echo MOD_BUILD_DIST: $MOD_BUILD_DIST
    eval BUILD_RPMS_TEST=\$BUILD_RPMS_$MOD_BUILD_DIST

	if [ "$BUILD_RPMS_TEST" ]; then
		if [ "$BUILD_RPMS" ]; then
			BUILD_RPMS=$BUILD_RPMS:$BUILD_RPMS_TEST
		else
			BUILD_RPMS=$BUILD_RPMS_TEST
		fi
	fi
fi

echo BUILD_RPMS: $BUILD_RPMS

ERROR=0

# Hier gehts los:

if [ -z "$1" ]; then
    # without parameter, we are in source directory
    SPECFILE=$(ls *.spec | awk '{print $1}')
    PACKAGE=$(sed -n -e 's/^Name:\W*//pi' <$SPECFILE | head -n 1)
    # use Version from BUILDSRC, 
    # because it has been modified by svn_build_prepare
    BUILDSRC_DIR=${BUILDTEMP}/src/${PACKAGE}
    VERSION=$(sed -n -e 's/^Version:\W*//pi' <$BUILDSRC_DIR/$SPECFILE | head -n 1)
elif [ -r "$1" ]; then
    # parameter is src.rpm file
    PACKAGE=`rpm -qp --qf "%{NAME}" $1`
    VERSION=`rpm -qp --qf "%{VERSION}" $1`
fi

echo $PACKAGE $VERSION $BUILD_DIST $BUILD_MODE

if [ -z "$PACKAGE" ]; then
    echo "nothing to build found!"
    exit 1
fi



# create file for buildvars (see $BUILDSCRIPT)
cat > $BUILDVARS <<EOF
# Variables for build-Prozess (export is needed in buildscript)
BUILD_ROOT=$BUILD_ROOT
BUILD_DIST=$BUILD_DIST
BUILD_RPMS=${DEST_DIR}/${BUILD_DIST}:$BUILD_RPMS

# Variables for execute the build-proggy
BUILD_MODE="$BUILD_MODE"
BUILD_PLACE=${BUILDTEMP}/src/${PACKAGE}
EXTRA_RPMS="$EXTRA_RPMS"
EOF

# starting Suse build (as root)
sudo $BUILDSCRIPT $BUILDVARS
#rm -f $BUILDVARS



mkdir -p ${DEST_DIR}/src
# delete all old versions of this package
for i in ${DEST_DIR}/src/${PACKAGE}-*.src.rpm; do
	if [ -f $i -a ${PACKAGE} = "`rpm -qp --qf "%{NAME}\n" $i`" ]; then
		rm $i
	fi
done

if !(cp -a ${BUILD_ROOT}/usr/src/packages/SRPMS/${PACKAGE}-${VERSION}-*.src.rpm ${DEST_DIR}/src 2> /dev/null); then 
	ERROR=4
fi

mkdir -p ${DEST_DIR}/${BUILD_DIST}

# if !(cp -a ${BUILD_ROOT}/usr/src/packages/RPMS/*/${PACKAGE}*${VERSION}-*.*.rpm ${DEST_DIR}/${BUILD_DIST} ); then 
# 	ERROR=8
# fi

# debug
#set -x
 
# check, if RPM with correct name and version is generated
if [ -z "`find ${BUILD_ROOT}/usr/src/packages/RPMS/ -name \"${PACKAGE}*${VERSION}-*.rpm\" 2>/dev/null`" ]; then
    ERROR=8
else
    # delete all old versions of this package
    for i in ${DEST_DIR}/${BUILD_DIST}/${PACKAGE}-*.rpm; do
        if [ -f $i -a ${PACKAGE} = "`rpm -qp --qf "%{NAME}\n" $i`" ]; then
            rm $i
        fi
    done

    # copy ALL RPMs, 
    # not only the one, that includes the target name.
    # this is done, 
    # because some source RPMs results the multiple RPMs
    find ${BUILD_ROOT}/usr/src/packages/RPMS/ -name "*.rpm" -exec cp -a {} ${DEST_DIR}/${BUILD_DIST} \;
fi

echo
if [ $ERROR -ne 0 ]; then

	echo "ERROR $ERROR while building packet $PACKAGE";
else
	echo "Build of \"${PACKAGE}\" completed!"
	echo "Packages can be found in ${DEST_DIR}"
fi
echo

exit $ERROR
