#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# $Id: dassmodus.py 11167 2010-10-06 15:01:40Z pstorz $


from PyQt4.QtCore import *
from PyQt4.QtGui import *



class DnDListWidget(QListWidget):

    def __init__(self, parent=None):
        super(DnDListWidget, self).__init__(parent)
        self.setAcceptDrops(True)
        self.setDragEnabled(True)


    def dragEnterEvent(self, event):
        if event.mimeData().hasText():  
            event.accept()
        else:
            event.ignore()


    def dragMoveEvent(self, event):
        if event.mimeData().hasText:
            event.setDropAction(Qt.MoveAction)
            event.accept()
        else:
            event.ignore()


    def dropEvent(self, event):
        if event.mimeData().hasText():
          text = event.mimeData().text()
          item = QListWidgetItem(text, self) 
          event.setDropAction(Qt.MoveAction)
          event.accept()
        else:
            event.ignore()

    def startDrag(self, supportedActions):      
        #print self.currentItem().text(0)
        currentItemName = self.currentItem().data
        #currentItemName = self.currentItem().text(0)
        mimeData = QMimeData()
        mimeData.setText(currentItemName)
        drag = QDrag(self)
        drag.setMimeData(mimeData)
        dropAction = drag.start(Qt.CopyAction)
    



class DnDTreeWidget(QTreeWidget):
  
  def __init__(self, parent=None):
    super(DnDTreeWidget, self).__init__(parent)
    #self.setAcceptDrops(True)
    self.setDragEnabled(True)

  def startDrag(self, supportedActions):      
        #print self.currentItem().text(0)
        currentItemName = self.currentItem().data
        #currentItemName = self.currentItem().text(0)
        mimeData = QMimeData()
        mimeData.setText(currentItemName)
        drag = QDrag(self)
        drag.setMimeData(mimeData)
        dropAction = drag.start(Qt.CopyAction)
