#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import *
from PyQt4.QtGui import * 

import socket
import string
import random
import Ui_baseconfigwizard


from nosferatu import bacresources, prettynames, auto_types



# TODO: move this into base_classes


# default values when creating a new resource
defaults = {
            'catalog' : 'MyCatalog',
            'messages': 'Standard',
            'type'    : 'Backup',
            'piddirectory'  : ['/var/run',
                               '/opt/bacula/working',
                               '"C:\\\\Program Files\\\\Bacula\\\\working"'],
            'workingdirectory' : ['/var/lib/bacula',
                                  '/opt/bacula/working',
                                  '"C:\\\\Program Files\\\\Bacula\\\\working"'],
            'queryfile' : [      '/usr/lib/bacula/query.sql',
                                  '"/opt/bacula/scripts/query.sql"'],     
            'type':  auto_types.jobtypes,
            'level': auto_types.joblevels,                
                                  
            }


class baseconfigwizard(QtGui.QWizard, Ui_baseconfigwizard.Ui_Wizard,):
  '''
  This wizard will do a base configuration of any bacula resource type.
  It displays all required items of the given resource and configures them
  If the configuration is successful, the resource will be given back,
  else None
  If the dirconfig is given, available resources are filled into 
  comboboxes (e.g. available filesets, etc) 
  '''
  
  def __init__(self, resource, dirconfig = None ,parent = None):
    super(baseconfigwizard, self).__init__()
    self.setupUi(self)
    self.resource = resource
    self.dirconfig = dirconfig
    
    print "got the following resource to configure: %s " % (resource)
    
    
    self.groupBox.setTitle('basic configuration of a "%s" resource.' % (resource.resourcetype))
    self.groupBox_2.setTitle('please provide the following information for the %s:' % (prettynames.PrettyNames[resource.resourcetype]))
    introtext = "The following information has to be configured:\n"
    
    for item in resource.items:
      if item.required: 
        introtext += resource.resourcetype + ' ' +item.name + '\n'
       
    
    self.introtextEdit.setText(introtext)
    
    row = 0
    for item in resource.items:
      if item.required:
        
        if self.dirconfig is not None: # fill the defaults with the resource types found in the director config
          for res in self.dirconfig.validresourcesset:
            ressources = self.dirconfig.getResourcesListByResType(res)
            for r in ressources:
              #print r.items_dict['name'].storage.value
              if not defaults.has_key(res):
                  defaults[res] = []
              if type(defaults[res]) is list:
                if not r.items_dict['name'].storage.value in  set(defaults[res]):
                  defaults[res].append(r.items_dict['name'].storage.value)
        
        
        # put the label
        newlabel = QtGui.QLabel(self.scrollAreaWidgetContents)
        #labeltext = prettynames.PrettyNames[resource.resourcetype] +' ' + prettynames.PrettyNames[item.name]
        labeltext =  prettynames.PrettyNames[item.name]
        newlabel.setText(labeltext)
        self.gridLayout_4.addWidget(newlabel, row, 0, 1, 1)
        
        # do we have default value information?
        if defaults.has_key(item.name):
          t = type(defaults[item.name])
          if t is str:
            newwidget = QtGui.QLineEdit(self.scrollAreaWidgetContents)
            self.wizardPage2.registerField(item.name + '*', newwidget) # register all fields as "required"
            newwidget.setText(defaults[item.name]) # set defaults
            
          elif t is list:
            newwidget = QtGui.QComboBox(self.scrollAreaWidgetContents)
            self.wizardPage2.registerField(item.name + '*', newwidget) # register all fields as "required"
            newwidget.addItems(defaults[item.name])
            newwidget.setEditable(True)
            newwidget.setCurrentIndex(0)
            #print defaults[item.name]
            
        else:
          newwidget = QtGui.QLineEdit(self.scrollAreaWidgetContents) 
          self.wizardPage2.registerField(item.name + '*', newwidget) # register all fields as "required"
          #self.wizardPage2.registerField(item.name + '*', newwidget) # register all fields as "required"
        
        self.gridLayout_4.addWidget(newwidget, row, 1, 1, 1) # add new widget (lineedit/combobox)
        #self.wizardPage2.registerField(item.name + '*', newwidget) # register all fields as "required"
          
        if item.name == 'address':
          newButton = QtGui.QPushButton(self.scrollAreaWidgetContents)
          newButton.setText('check')
          self.gridLayout_4.addWidget(newButton, row, 2, 1, 1)
          self.addressLineEdit = newwidget
          self.connect(newButton,
                       SIGNAL("clicked()"),
                       self.onaddrCheckButtonClicked
                       )
      
          
        elif item.name == 'password':
          newButton = QtGui.QPushButton(self.scrollAreaWidgetContents)
          newButton.setText('generate')
          self.gridLayout_4.addWidget(newButton, row, 2, 1, 1)
          self.passwordLineEdit = newwidget
          self.connect(newButton,
                       SIGNAL("clicked()"),
                       self.onpwgenPasswdClicked
                       )
        row += 1
        
    
        
        

  def initializePage(self,pagenumber):
    if pagenumber ==  2:
      for item in self.resource.items:
        if item.required:
          if defaults.has_key(item.name):
            t = type(defaults[item.name])
            if t is list:
              #print "%s:%s" %(item.name, self.field(item.name))
              idx,x = self.field(item.name).toInt()
              #print item.name , self.field(item.name).toInt()
              item.setValue(defaults[item.name][idx])
            elif t is str:
              item.setValue(str(self.field(item.name).toString()))
          else:
            #print  item.name, self.field(item.name).toString()
            item.setValue(str(self.field(item.name).toString()))
            
      self.previewtextEdit.setText(str(self.resource))
      
      
    
  
  def onpwgenPasswdClicked(self):
    self.passwordLineEdit.setText(bacresources.genPw(None,32))
    
  def onaddrCheckButtonClicked(self):
    hostname = str(self.addressLineEdit.text())
    ip = self.check_hostname(hostname) 
    if ip != None:
      reply = QMessageBox.information(self,
                                   "hostname OK",
                                   "check successful: \n\n \"%s\" \n is at\n %s" % (hostname, ip) ,
                                   QMessageBox.Ok)
    else:
      reply = QMessageBox.warning(self,
                                   "hostname ERROR",
                                   "\"%s\" can NOT be resolved!" % (hostname) ,
                                   QMessageBox.Ok)


  def check_hostname(self,hostname):
    '''
    try to resolve the given hostname
    returns the IP or NONE if not resolvable
    '''
    if len(hostname) == 0:
      return None
    try:
      ip = socket.gethostbyname(hostname)
      return ip
    except:
      return None
  






if __name__ == "__main__":
  import sys
#def main():
  print "started"   
  app = QtGui.QApplication(sys.argv)
  app.setOrganizationDomain("dass-it.de")
  app.setOrganizationName("dassIT GmbH")
  app.setApplicationName("dassModus")
  app.setWindowIcon(QIcon(":/icons/dassit_logo.png")) 
  
  
  # create a bacula director configuration
  dirconf = bacresources.DirectorConfig('')
  dirstring = '''
  Director {
  Name = gonzo-dir
  Messages = Daemon
  Password = "0DntXXl7DVkNYYRApYdhKKoy2Huq1CVHwIRAKUwgNA86"
  Pid Directory = "/var/run"
  Query File = "/usr/lib/bacula/query.sql"
  VerID = " | configuration file created on :Thu Jun 17 16:30:45 2010"
  Working Directory = "/var/lib/bacula"
}
JobDefs {
  Name = "DefaultJob"
  Client = gonzo-fd
  Fileset = "Full Set"
  Level = Incremental
  Messages = Standard
  Pool = Default
  Schedule = "WeeklyCycle"
  Storage = FileStorage
  Type = Backup
}
Job {
  Name = "BackupClient1"
  JobDefs = "DefaultJob"
  Write Bootstrap = "/var/lib/bacula/Client1.bsr"
}
Job {
  Name = "BackupCatalog"
  Fileset = "Catalog"
  JobDefs = "DefaultJob"
  Level = Full
  Priority = 11
  Run After Job = "/usr/lib/bacula/delete_catalog_backup"
  Run Before Job = "/usr/lib/bacula/make_catalog_backup bacula bacula"
  Schedule = "WeeklyCycleAfterBackup"
  Write Bootstrap = "/var/lib/bacula/BackupCatalog.bsr"
}
Fileset {
  Name = "Full Set"
  Include {
    File = /usr/sbin
    Options {
      Signature = MD5
    }
  }
  Exclude {
    File = /var/lib/bacula
    File = /tmp
    File = /proc
    File = /tmp
    File = /.journal
    File = /.fsck
  }
}

Fileset {
  Name = "Full Set2"
  Include {
    File = /usr/sbin
    Options {
      Signature = MD5
    }
  }
  Exclude {
    File = /var/lib/bacula
    File = /tmp
    File = /proc
    File = /tmp
    File = /.journal
    File = /.fsck
  }
}


Schedule {
  Name = "WeeklyCycle"
  Run = Full 1st sun at 23:05
  Run = Differential 2nd-5th sun at 23:05
  Run = Incremental mon-sat at 23:05
}
Client {
  Name = gonzo-fd
  Address = localhost
  Catalog = MyCatalog
  File Retention = 30 days
  Job Retention = 6 months
  Password = "H/cjI5EOGYbiQ1jWb+1DSxQZc8VKncvt9GOuyDKQvE5E"
}
Client {
  Name = second-client-fd
  Address = localhost
  Catalog = MyCatalog
  File Retention = 30 days
  Job Retention = 6 months
  Password = "H/cjI5EOGYbiQ1jWb+1DSxQZc8VKncvt9GOuyDKQvE5E"
}


Storage {
  Name = FileStorage
  Address = localhost
  Device = FileStorage
  Media Type = FileStorage
  Password = "/IUTExp+79Y0ipxZ5cZDq26Pp1Vcq5xI0bszHyTa4+TX"
}
Messages {
  Name = Standard
  Append = "/var/lib/bacula/log" = all, !skipped
  Catalog = all
  Console = all, !skipped, !saved
  Mail = root@localhost = all, !skipped
  Mail Command = "/usr/sbin/bsmtp -h localhost -f \"\(Bacula\) \<%r\>\" -s \"Bacula: %t %e of %c %l\" %r"
  Operator = root@localhost = mount
  Operator Command = "/usr/sbin/bsmtp -h localhost -f \"\(Bacula\) \<%r\>\" -s \"Bacula: Intervention needed for %j\" %r"
}

Pool {
  Name = Default
  Pool Type = Backup
  Volume Retention = 365 days
}
Pool {
  Name = Scratch
  Pool Type = Backup
}

  '''
  refdirconfig = bacresources.DirectorConfig(dirstring)
  
  for res in dirconf.resources:
    #print res.items_dict['name']
    print res.resourcetype
    if res.resourcetype == "client":
      r = res
  
  
  wizard = baseconfigwizard(r,refdirconfig)
  if wizard.exec_():
    newresource = wizard.resource
    print newresource
  else:
    print "no"
  #wizard.show()
  
  
  sys.exit(app.exec_())
  
  
