#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import fuse
import stat
import errno
import os
import pexpect
import sys

fuse.fuse_python_api = (0, 2)

###### bconsole
################

LOG_FILENAME        = '/tmp/baculafs.log'
LOG_BCONSOLE        = '/tmp/bconsole.log'
LOG_BCONSOLE_DUMP   = '/tmp/bconsole.out'


#BACULA_CMD = 'strace -f -o /tmp/bconsole.strace /usr/sbin/bconsole -n'
BACULA_CMD = '/usr/sbin/bconsole -n'
# .clients
# 5: ting-fd
BACULA_CLIENT='5'

BCONSOLE_CMD_PROMPT='\*'
BCONSOLE_SELECT_PROMPT='Select item:.*'
BCONSOLE_RESTORE_PROMPT='\$ '


class Bconsole:

    #bconsole = None

    def __init__(self, client=BACULA_CLIENT):
        #logging.basicConfig(filename=LOG_BCONSOLE,level=logging.DEBUG,)
        logging.debug('BC init')
        self.bconsole = pexpect.spawn( BACULA_CMD, logfile=file(LOG_BCONSOLE_DUMP, 'w'), timeout=10 )
        self.bconsole.setecho( False )
        self.bconsole.expect( BCONSOLE_CMD_PROMPT )
        self.bconsole.sendline( 'restore' )
        #self.bconsole.expect( BCONSOLE_SELECT_PROMPT )
        self.bconsole.sendline( "5" )
        #self.bconsole.expect( BCONSOLE_SELECT_PROMPT )
        self.bconsole.sendline( BACULA_CLIENT )
        self.bconsole.expect( BCONSOLE_RESTORE_PROMPT )
        logging.debug( "BC alive: " + str(self.bconsole.isalive()) )
        logging.debug('BC init done')


    def ls(self, path):

        path = path + "/"
        logging.debug( "BC ls(" + path + ")" )

        self.bconsole.sendline( 'cd ' + path )
        #self.bconsole.expect( BCONSOLE_RESTORE_PROMPT, timeout=10 )
        #self.bconsole.sendline( 'pwd' )

        index = self.bconsole.expect( ["cwd is: " + path + "[/]?", BCONSOLE_RESTORE_PROMPT, pexpect.EOF, pexpect.TIMEOUT ] )
        logging.debug( "BC ls: cd result: " + str(index) )

        if index == 0:
            # path ok, now wait for prompt
            self.bconsole.expect( BCONSOLE_RESTORE_PROMPT )
        elif index == 1:
            #print "wrong path"
            return
        elif index == 2:
            print "error EOF"
            raise
        elif index == 3:
            print "error TIMEOUT"
            return

        self.bconsole.sendline( 'ls' )
        self.bconsole.expect( BCONSOLE_RESTORE_PROMPT )
        lines = self.bconsole.before.splitlines()
        logging.debug( "BC ls: " + str(lines) )
        return lines

###############

hello_world_path = "/helloworld"
hello_world = "Hello World!"

class BaculaFS(fuse.Fuse):

    TYPE_NONE = 0
    TYPE_FILE = 1
    TYPE_DIR  = 2

    files = { '': {'type': TYPE_DIR} }

    def __init__(self, *args, **kw):
        logging.basicConfig(filename=LOG_FILENAME,level=logging.DEBUG,)
        logging.debug('init')
        #self.console = Bconsole()
        fuse.Fuse.__init__(self, *args, **kw)
        #logging.debug('init finished')

    def _getdir(self, path):

        # TODO: may cause problems with filenames that ends with "/" 
        path = path.rstrip( '/' )
        logging.debug( "_getdir(" + path + ")" )

        if (path in self.files):
            logging.debug( "  _getdir(" + path + ")=" + str(self.files[path]) )
            if self.files[path]['type'] == self.TYPE_FILE:
                logging.debug( "  type: file" )
                return self.files[path]
            elif ((self.files[path]['type'] == self.TYPE_DIR) and ('files' in self.files[path])):
                logging.debug( "  type: dir (cached)" )
                return self.files[path]

        try:
            files = Bconsole().ls(path)
            logging.debug( "  files: " + str( files ) )
            self.files[path] = {}
            self.files[path]['type']  = self.TYPE_DIR
            self.files[path]['dirs']  = [ ".", ".." ]
            self.files[path]['files'] = []
            for i in files:
                if i.endswith('/'):
                    # we expect a directory
                    # TODO: error with filesnames, that ends with '/'
                    i = i.rstrip( '/' )
                    self.files[path]['dirs'].append(i)
                    if not (i in self.files):
                        self.files[path + "/" + i] = { 'type': self.TYPE_DIR }
                else:
                    self.files[path]['files'].append(i)
                    self.files[path + "/" + i] = { 'type': self.TYPE_FILE }

        except:
            logging.debug( "Unexpected error:" + sys.exc_info()[0] )
            logging.error( "no access to path " + path )
            self.files[path] = { 'type': TYPE_NONE }
        logging.debug( "  " + str( self.files[path] )  )
        return self.files[path]



    # TODO: only works after readdir for the directory (eg. ls)
    def getattr(self, path):
        logging.debug( "getattr " + path )

        st = fuse.Stat()

        #file = self._getdir( path )

        # TODO: may cause problems with filenames that ends with "/" 
        path = path.rstrip( '/' )
        file = self.files[path]

        if file['type'] == self.TYPE_FILE:
            st.st_mode = stat.S_IFREG | 0444
            st.st_nlink = 1
            st.st_size  = 0
        elif file['type'] == self.TYPE_DIR:
            st.st_mode = stat.S_IFDIR | 0755
            st.st_nlink = 2
        else:
            return -errno.ENOENT
        return st



    def readdir(self, path, offset):
        logging.debug( "readdir " + path + "(offset: " + str(offset) + ")" )

        dir = self._getdir( path )

        #logging.debug( "  readdir: type: " + str( dir['type'] ) )
        #logging.debug( "  readdir: dirs: " + str( dir['dirs'] ) )
        #logging.debug( "  readdir: file: " + str( dir['files'] ) )

        if dir['type'] != self.TYPE_DIR:
            return -errno.ENOENT
        else:
            return [fuse.Direntry(f) for f in dir['files'] + dir['dirs']]

    #def open( self, path, flags ):
        #logging.debug( "open " + path )
        #return -errno.ENOENT

    #def read( self, path, length, offset):
        #logging.debug( "read " + path )
        #return -errno.ENOENT

if __name__ == "__main__":
    fs = BaculaFS()
    fs.parse()
    fs.main()
