#!/bin/bash

export http_proxy=http://proxy:3128
export ftp_proxy=http://proxy:3128

NSCA_CMD="/usr/local/bin/nagios_send_nsca.sh"

PROJECTS="
http://download.videolan.org/pub/vlc/SuSE/11.2/
http://download.videolan.org/pub/vlc/SuSE/12.1/
"

# TODO:
# not working, because dir listings are forbidden
# http://download.nvidia.com/opensuse/11.2/
# (with hftp://download.nvidia.com/opensuse/11.2/ directory listings are possible,
#  but file access in denied)

SUCCESSFUL=""
FAILED=""

DEST="/anlagen/vmlxlamp/repo/"

cd $DEST


for url in $PROJECTS; do
  echo $url
  protocol=`sed -r "s|^([a-zA-Z]+)://.*|\1|" <<< $url`
  host=`sed -r "s|^$protocol://([^/]+)/.*|\1|" <<< $url`
  path=`sed -r "s|$protocol://$host||" <<< $url`
  mkdir -p $host/$path
  set -x
  if ! lftp -c "open -e \"mirror --verbose=1 --continue --delete $path/. $DEST/$host/$path\" ${protocol}://${host}"; then
	FAILED="$FAILED $url"
  else
	SUCCESS="$SUCCESS $url"
  fi
  set +x
done

# adapt repository sources
for i in `find $DEST -name "*.repo" -a ! -name "vermkv-*.repo"`; do
	basename=`basename $i`
	dirname=`dirname $i`
        sed "s|http://|http://install.vermkv/freigabe/|" $i > $dirname/vermkv-$basename 
done

/usr/local/sbin/mirror-report-errors.sh mirror-urls "$SUCCESS" "$FAILED" 
