#!/bin/bash

SOURCE_OPENSUSE="ftp5.gwdg.de::pub/opensuse/"

REPOS="repositories/home:/dassit
"

#
# disabled repos:
#
#distribution/11.2/repo update/11.2 distribution/12.1/repo update/12.1

RSYNC_DELETE="--delete"

#RSYNC_OPTS="-v -rlLptx --safe-links --stats \
#        --exclude=*.src.rpm --exclude=*.nosrc.rpm --exclude=*.spm \
#        --exclude=*.patch.rpm"

RSYNC_OPTS="-v -rlLptx --safe-links --stats"

DEST="/space/installtree/install/download.opensuse.org"

rsync_if_exists()
{
	src=$1
	dest=$2

	rsync -q $src || return 1
	echo rsync-quelle $src gefunden.
	[ -d "$dest" ] || return 2
	rsync $RSYNC_OPTS $RSYNC_DELETE $src ./$dest
}

# ---------------- mirror openSUSE repositories ------------------------
FAILED_REPOS=""
SUCCESSFUL=""

cd $DEST

for DIR in $REPOS 
do
  SOURCE_DIR=${SOURCE_OPENSUSE}/${DIR}/.
  DEST_DIR=${DEST}/${DIR}/.
  mkdir -p ${DEST_DIR}
  rsync_if_exists  "${SOURCE_OPENSUSE}$DIR/" "$DIR"
  case $? in
	1) 	echo Distribution $DIR nicht gefunden
		FAILED_REPOS="$FAILED_REPOS $DIR"
		;;
	2)	echo Zielverzeichnis $(pwd)/$DIR nicht vorhanden
		FAILED_REPOS="$FAILED_REPOS $DIR"
		;;
	0)
		SUCCESSFUL="$SUCCESSFUL $DIR"
		;;
	*)
		echo Fehler $?
		FAILED_REPOS="$FAILED_REPOS $DIR"
		;;
  esac
done

# /usr/local/sbin/mirror-report-errors.sh mirror-osb "$SUCCESSFUL" "$FAILED_REPOS"
# 
# # adapt repository sources
# for i in `find $DEST/repositories -name "*.repo" -a ! -name "vermkv-*.repo"`; do
# 	basename=`basename $i`
# 	dirname=`dirname $i`
#         sed "s|http://|http://install.vermkv/freigabe/|" $i > $dirname/vermkv-$basename 
# done

