#
# some usefull aliases
#
# WARNING:
#   bash aliases are not inherited to subshells,
#   therefore this aliases are only available at login shells.
#   If theses aliases should be available everywhere,
#   add following line to /etc/bash.bashrc.local:
#   source /etc/profile.d/dass-it.sh

alias_set()
{
  name=$1
  shift
  alias $name >/dev/null 2>&1 || alias $name="$@"
}

alias_set l "ls -la"
alias_set  .. "cd .."
alias_set  ... "cd ../.."
alias_set lsst 'find -type f -printf "%T@  %T+   %P\n" | sort -n'
alias_set rpm-disturl 'rpm -q --qf "%{DISTURL}\n"'
alias_set rpm-sortsize 'rpm -qa --qf "%{SIZE} %{NAME}\n" | sort -n'
alias_set rscp 'rsync -av --progress --compress'
