#!/bin/sh

BUILD_CMD=build

if [ $# -eq 1 ]; then
	# Datei mit den Variablen fuer den build-Prozess einlesen
	if [ -r $1 ]; then
		. $1
		[ -n "$BUILD_ROOT" ] && export BUILD_ROOT
		[ -n "$BUILD_DIST" ] && export BUILD_DIST
		[ -n "$BUILD_RPMS" ] && export BUILD_RPMS
		[ -n "$BUILD_PLACE" ] && [ -d $BUILD_PLACE ] && cd $BUILD_PLACE
		if [ -n "$EXTRA_RPMS" ]; then
			$BUILD_CMD $BUILD_MODE -X "$EXTRA_RPMS"
		else
			$BUILD_CMD $BUILD_MODE
		fi
	else
		echo "File $1 not readable"
		exit 3
	fi
else
	echo "usage: `basename $0` <file for build-definitions>"
	exit 2
fi

# vim: sw=4 ts=4 noautoindent
