#!/bin/bash

# dasscm_remote_update is intended for systems
# where a local dasscm installation is not possible
# but ssh and rsync is available.
# In this case, 
# the files from the local repository checkout 
# are updated to the current content.
# Use only, if a local dasscm installation is not possbile!

DIR="$1"

set -o errexit -o nounset

usage()
{
echo "
  usage: $0 hostname
  hostname must be identical with the repository path
"
exit 1
}

OPTIONS=${DASSCM_RSYNC_OPTIONS:-""}
REMOTE_USER=${DASSCM_REMOTE_USER:-"root"}

if [ -z "$DIR" ]; then
    usage
fi

if [ ! -d "$DIR" ]; then
    echo
    echo "  failed to access directory $DIR"
    usage
fi

#   start at an current repository checkout of morbo.
#   only already existing files will be updated.
#   If you want to add more files, 
#   create the file in the repository and re-run this script
cd $DIR
svn up || (echo "failed to update repository $DIR"; usage)
FILELIST=`mktemp`
svn ls -R > $FILELIST
SERVER=`basename "$PWD"`
rsync -av --existing --files-from $FILELIST $OPTIONS $REMOTE_USER@$SERVER:/. . || (echo "FAILED to transfer dasscm files. Failed to access server $SERVER via ssh/rsync?"; usage)
rm $FILELIST
echo "updated file must be commited manually"
