
import sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui
import Ui_schedule

import calendar
calendar.setfirstweekday(calendar.SUNDAY)

#from nosferatu import configrules,directive,scheduleparser
#from nosferatu import configrules,directive,scheduleparser
from nosferatu import scheduleparser, auto_types, prettynames
#import scheduleparser # TODO: rename this file

#import directive


weekdays = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat')
ordinals = ('1st', '2nd', '3rd', '4th', '5th')
months = ('Jan','Feb', 'Mar', 'Apr', 'May', 'Jun', 
          'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec')

periods =   ['monthly', 'weekly', 'daily', 'hourly']
periods.reverse()
# lists of checkboxes 
woyList =  []
womList = []
monthdayList = []
weekdayList  = []
monthList = []
periodList = []

#TODO: put all definitions this in a central file 
INTERNALLY_REFERENCED_ITEMS = set(['fileset',
                                  'client' ,
                                  'catalog',
                                  'messages',
                                  'schedule',
                                  'storage',
                                  'jobdefs',
                                  'pool',
                                  'incrementalbackuppool',
                                  'fullbackuppool',
                                  'differentialbackuppool',
                                  'job',
                                  'basejob',
                                  'device',
                                  ])


class indexCheckBox(QCheckBox):
  def __init__(self, parent, index):
    super(indexCheckBox, self).__init__(parent)
    self.index = index


    
class RunentryDialog(QDialog, Ui_schedule.Ui_Dialog):
  def __init__(self, parent=None, runentry=None, parentconfig=None):
    super(RunentryDialog, self).__init__(parent)
    self.setupUi(self)
    self.parentconfig = parentconfig
    self.runentry = runentry
    
    self.connect(self.buttonBox, SIGNAL("accepted()"),
                     self, SLOT("accept()"))
    self.connect(self.buttonBox, SIGNAL("rejected()"),
                     self, SLOT("reject()"))
    self.setWindowTitle("Edit Schedule Run Entry")

    
    
    
    # enable / disable groupboxes depending on status of runentry
    if len(self.runentry.sched['woy']) == 0:
      self.weekOfYearGroupBox.setChecked(False)
    else:
      self.weekOfYearGroupBox.setChecked(True)
    
    if len(self.runentry.sched['mday']) == 0:
      self.monthDayGroupBox.setChecked(False)
    else:
      self.monthDayGroupBox.setChecked(True)  
      
    if len(self.runentry.sched['month']) == 0:
      self.monthGroupBox.setChecked(False)
    else:
      self.monthGroupBox.setChecked(True)
    
    self.periodGroupBox.setChecked(False)
    for period in periods:
      if self.runentry.sched[period]:
        self.periodGroupBox.setChecked(True)
    
    self.overridesBox.setChecked(False)
    for override in scheduleparser.overrides:          
      if self.runentry.overrides[override] is not None:
        self.overridesBox.setChecked(True)
      
    # fill the weeks of the year
    for i in range(1,54):
      #self.checkBox = QtGui.QCheckBox(self.weekOfYearGroupBox)
      self.checkBox = indexCheckBox(self.weekOfYearGroupBox,i)
      self.checkBox.setObjectName(str(i))
      self.checkBox.setObjectName('weekOfYear' + str(i))
      self.checkBox.setText(str(i))
      # set the checkbox according to the runentry's status
      if i in self.runentry.sched['woy']:
        self.checkBox.setChecked(True)
      else:
        self.checkBox.setChecked(False)

      self.gridLayout_6.addWidget(self.checkBox, i/10, i%10, 1, 1)
      self.connect(self.checkBox ,SIGNAL("stateChanged(int)"), self.updateYearWeek)
        
      woyList.append(self.checkBox)
      
    # fill monthday
    for i in range(1,32):        
      self.checkBox = indexCheckBox(self.monthDayGroupBox, i)
      self.checkBox.setObjectName('monthDay' + str(i))
      self.checkBox.setText(str(i))
      # set checkbox
      if i in self.runentry.sched['mday']:
        self.checkBox.setChecked(True)
      else:
        self.checkBox.setChecked(False)
        
      self.gridLayout_4.addWidget(self.checkBox, i/7, i%7, 1, 1)
      self.connect(self.checkBox , SIGNAL("stateChanged(int)"), self.updateMonthDay)
      monthdayList.append(self.checkBox)

    for day in range(7):
      #print calendar.day_name[day]
      #print weekdays[day]
      self.checkBox = indexCheckBox(self.weekDayGroupBox, day)
      self.checkBox.setObjectName(weekdays[day])
      self.checkBox.setText(weekdays[day])
      # set checkbox
      if day in self.runentry.sched['wday']:
        self.checkBox.setChecked(True)
      else:
        self.checkBox.setChecked(False)
      self.gridLayout_8.addWidget(self.checkBox, day/5, day%5, 1, 1)
      self.connect(self.checkBox , SIGNAL("stateChanged(int)"), self.updateWeekDay)
      weekdayList.append(self.checkBox)
      
      
    for month in range(1,13):
      #print calendar.month_name[month]
      self.checkBox = indexCheckBox(self.monthGroupBox, month)
      self.checkBox.setObjectName(calendar.month_name[month])
      self.checkBox.setText(QString(calendar.month_name[month]))
      # set checkbox
      if month-1 in self.runentry.sched['month']:
        self.checkBox.setChecked(True)
      else:
        self.checkBox.setChecked(False)
        
      self.gridLayout_3.addWidget(self.checkBox, (month-1)/3, (month-1)%3, 1, 1)
      self.connect(self.checkBox , SIGNAL("stateChanged(int)"), self.updateMonth)
      monthList.append(self.checkBox)
      
    for week in range(5):
      #print ordinals[week]
      self.checkBox = indexCheckBox(self.weekOfMonthGroupBox, week)
      self.checkBox.setObjectName(ordinals[week])
      self.checkBox.setText(ordinals[week])
      # set checkbox
      if week in self.runentry.sched['wom']:
        self.checkBox.setChecked(True)
      else:
        self.checkBox.setChecked(False)
      #self.gridLayout_5.addWidget(self.checkBox)
      self.gridLayout_5.addWidget(self.checkBox, 0, week, 1, 1)
      self.connect(self.checkBox , SIGNAL("stateChanged(int)"), self.updateWeekOfMonth)
      womList.append(self.checkBox)
    
    
    for period in periods:
      self.checkBox = indexCheckBox(self.periodGroupBox, period)
      self.checkBox.setObjectName(period)
      self.checkBox.setText(period)
      if self.runentry.sched[period]:
        self.checkBox.setChecked(True)
      else:
        self.checkBox.setChecked(False)
      #self.gridLayout_5.addWidget(self.checkBox)
      self.verticalLayout.addWidget(self.checkBox)
      self.connect(self.checkBox , SIGNAL("stateChanged(int)"), self.updatePeriod)
      periodList.append(self.checkBox)
      
    
    i = 0
    for override in scheduleparser.overrides:
        # label
        self.label = QtGui.QLabel(self.overridesBox)
        self.label.setObjectName(override+'label')
        self.label.setText(override)
        #self.label.setText(directive.PrettyNames[override])
        self.gridLayout_7.addWidget(self.label, 2*i/4, 2*i%4, 1, 1)
        
        
        if override == 'priority':
          SpinBox = QtGui.QSpinBox()
          SpinBox.setObjectName(override)
          SpinBox.setMinimum(1)
          SpinBox.setMaximum(99)
          SpinBox.setValue(10)
          self.connect( SpinBox, 
                          SIGNAL("valueChanged(int)"),
                           self.onSpinboxChanged )
          self.gridLayout_7.addWidget(SpinBox, 2*i/4 , (2*i%4) + 1, 1, 1)
          
        elif override not in scheduleparser.bool_overrides:
          # combobox/checkbox
          self.ComboBox = QtGui.QComboBox(self.overridesBox)
          self.ComboBox.setObjectName(override)
          self.ComboBox.addItem('') # empty
          self.ComboBox.setEditable(True)
          # if parentconfig is available, fill overrides with possible values
          if self.parentconfig is not None:
            if override.endswith('pool'):
              override = 'pool'
            if override.endswith('job'):
              override = 'job'
              
            for r in self.parentconfig.getResourcesListByResType(override):
              self.ComboBox.addItem(r.items_dict['name'].storage.value)
              self.ComboBox.setEditable(False) # remove editable if we have info
              
          
          if self.ComboBox.isEditable():
            if self.runentry.overrides[override] is not None:
              self.ComboBox.addItem(self.runentry.overrides[override])
            self.connect( self.ComboBox.lineEdit(), 
                          SIGNAL("editingFinished()"),
                           self.onLineeditChanged )   
          if override == 'level':
            self.ComboBox.setEditable(False)
            for lvl in auto_types.joblevels:
              self.ComboBox.addItem(prettynames.prettyName(lvl))
          
            
          

          
          #self.ComboBox.addItem(override)
          
          
            
            
          self.connect( self.ComboBox, 
                          SIGNAL("currentIndexChanged(int)"),
                           self.onComboboxChanged )
          
          #self.connect( self.ComboBox, 
          #                SIGNAL("editingFinished(int)"),
          #                 self.onComboboxChanged )
          self.gridLayout_7.addWidget(self.ComboBox, 2*i/4 , (2*i%4) + 1, 1, 1)
                    
        else:
          self.ComboBox = QtGui.QComboBox(self.overridesBox)
          self.ComboBox.setObjectName(override)
          self.ComboBox.addItem('') # empty
          self.ComboBox.addItem('Yes') # empty
          self.ComboBox.addItem('No') # empty
          #self.ComboBox.setEditable(True)
          self.gridLayout_7.addWidget(self.ComboBox, 2*i/4, (2*i%4)+1, 1, 1)
          self.connect( self.ComboBox, 
                          SIGNAL("currentIndexChanged(int)"),
                           self.onComboboxChanged )
          
          #self.checkBox = QtGui.QCheckBox(self.overridesBox)
          ##self.checkBox.setTristate(True)
          #self.checkBox.setObjectName(override)
          #self.connect(self.checkBox , SIGNAL("stateChanged(int)"), self.onOverridesCheckbox)
          #self.gridLayout_7.addWidget(self.checkBox, 2*i/4 , (2*i%4)+1, 1, 1)
        i += 1
    
    self.updateOverrides() # set the overrides according to the values
    # connect signals  
    #QTimeEdit.tim
    tmptime=QTime()
    tmptime.setHMS(self.runentry.hour, self.runentry.minute, 0)
    self.timeEdit.setTime(tmptime)
    self.connect(self.timeEdit , SIGNAL("timeChanged(QTime)"), self.updateTime)  
    #self.connect(self.actionNew_director, SIGNAL("triggered()"), self.newDirector
    self.createOutput()
    
  def updatePreviewTable(self):   
    self.previewTableWidget.setColumnCount(6)
    
    self.previewTableWidget.setHorizontalHeaderLabels(['WD','D','M','Y','Time','Overrides'])
    row = 0
    self.previewTableWidget.setRowCount(len(self.runentry.runTimes))
    self.previewTableWidget.setAlternatingRowColors(True)
    for dt in self.runentry.runTimes:
      #bgcolor = QColor("white")
      
      wday =  scheduleparser.weekdays[(dt.weekday()+1)%7]

      item = QtGui.QTableWidgetItem(wday)
      #item.setBackgroundColor(bgcolor)
      self.previewTableWidget.setItem(row, 0, item)
      
      
      item = QtGui.QTableWidgetItem(str(dt.day))
      #item.setBackgroundColor(bgcolor)
      self.previewTableWidget.setItem(row, 1, item)
      
      item = QtGui.QTableWidgetItem(scheduleparser.months[dt.month-1])
      #item.setBackgroundColor(bgcolor)
      self.previewTableWidget.setItem(row, 2, item)
      
      #if dt.month %2:
      #  bgcolor = QColor("light gray")
      #else:
      #  bgcolor = QColor("white")
      item = QtGui.QTableWidgetItem(str(dt.year))
      #item.setBackgroundColor(bgcolor)
      self.previewTableWidget.setItem(row, 3, item)
      
      item = QtGui.QTableWidgetItem("%02d:%02d" % (dt.hour,dt.minute))
      #item.setBackgroundColor(bgcolor)
      self.previewTableWidget.setItem(row, 4, item)
      
      # overrides
      s = ''
      for ov,val in self.runentry.overrides.iteritems():
        if val != None:
          s += "%s=%s " %(ov,val)
      if s == '':
        s = '[None]'
      item = QtGui.QTableWidgetItem(s)
      #item.setBackgroundColor(bgcolor)
      self.previewTableWidget.setItem(row, 5, item)
      
      row += 1
      
    self.previewTableWidget.resizeRowsToContents()
    self.previewTableWidget.resizeColumnsToContents()
    
  def updateOverrides(self):
    '''update the overrides comboboxes and checkboxes 
    from runentry data
    '''
    for child in self.overridesBox.children():
      if type(child).__name__ == 'QComboBox':
        override = str(child.objectName())
        print override
        overrideval = self.runentry.overrides[override]
        if overrideval is not None:
          idx = child.findText(overrideval)
          if idx != -1:
            child.setCurrentIndex(idx)
            
      elif type(child).__name__ == 'QCheckBox':
        override = str(child.objectName())
        print override
        overrideval = self.runentry.overrides[override]
        if overrideval is not None:
          if overrideval.lower() == "yes":
            child.setChecked(True)
          else:
            child.setChecked(False)
            
      elif type(child).__name__ == 'QSpinBox':
        override = str(child.objectName())
        overrideval = self.runentry.overrides[override]
        if overrideval is None:
          child.setValue(10)
        else:
          child.setValue(int(overrideval))
          

  def onSpinboxChanged(self):
    print "spinbox was changed by:" , self.sender().objectName() , "to:" , str(self.sender().value()).lower().replace(' ','')
    if self.sender().value() == 10:
      self.runentry.overrides[str(self.sender().objectName())] = None  # do not write Priority if default value is given 
    else:
      self.runentry.overrides[str(self.sender().objectName())] = self.sender().value()
    self.createOutput()
  
  def onComboboxChanged(self):
    if self.sender().currentText() == '':  # delete this override
      self.runentry.overrides[str(self.sender().objectName())] = None
    else:
      self.runentry.overrides[str(self.sender().objectName())] = str(self.sender().currentText())
    print "combobox was changed by:" , self.sender().objectName() , "to:" , str(self.sender().currentText()).lower().replace(' ','')
    self.createOutput()
  
  def onOverridesCheckbox(self):
    print "onOverridesCheckbox called"
    print self.sender().objectName()
    if self.sender().isChecked():
      self.runentry.overrides[self.sender().objectName()] ="yes"
    else:
      self.runentry.overrides[self.sender().objectName()] ="no"
    self.createOutput()
      
    
  def onLineeditChanged(self):
      print "Lineedit was changed by:" , self.sender().objectName() , "to:" , self.sender().text()
  
  def updatePeriod(self):
    if self.sender().isChecked():
      print self.sender().text()
      self.runentry.sched[str(self.sender().text())].add(self.sender().text())
    else:
      self.runentry.sched[str(self.sender().text())].clear()
    self.createOutput()

  
  def updateTime(self):
    print "updateResult"
    global timeOutput
    # get time from time Widget
    self.runentry.hour = self.timeEdit.time().hour()
    self.runentry.minute = self.timeEdit.time().minute()
    self.createOutput()
  
  def updateWeekDay(self):
    if self.sender().isChecked():
      self.runentry.sched['wday'].add(self.sender().index)
    else:
      self.runentry.sched['wday'].remove(self.sender().index)
    self.createOutput()

  def updateYearWeek(self):
    if self.sender().isChecked():
      self.runentry.sched['woy'].add(self.sender().index)
    else:
      self.runentry.sched['woy'].remove(self.sender().index)
    self.createOutput()
    
  def updateMonth(self):
    if self.sender().isChecked():
      self.runentry.sched['month'].add(self.sender().index-1)
    else:
      self.runentry.sched['month'].remove(self.sender().index-1)
    self.createOutput()

  def updateMonthDay(self):
    if self.sender().isChecked():
      self.runentry.sched['mday'].add(self.sender().index)
    else:
      self.runentry.sched['mday'].remove(self.sender().index)
    self.createOutput()
  
  def updateWeekOfMonth(self):
    if self.sender().isChecked():
      self.runentry.sched['wom'].add(self.sender().index)
    else:
      self.runentry.sched['wom'].remove(self.sender().index)
    self.createOutput()
    

  def createOutput(self):
    self.resultLineEdit.setText(str(self.runentry))
    self.runentry.calcStarttimes()
    self.updatePreviewTable()
    print self.runentry.overrides
  
if __name__ == "__main__":
    import sys
    from nosferatu import scheduleparser
    app = QApplication(sys.argv)
    #s = 'level=Full on Jul,Aug,Oct,sep 1,2,3,4,10,16 first,2nd,3rd,fifth Tue,Wed w23,w26,w28,w37 monthly weekly at 12:32'
    
    #s = 'Level=Full Storage=Blafasel 1st Mon Jan at 23:05'
    s = 'level=Full pool="wilmak17-geradePool" on    mon-fri w00,w02,w04,w06,w08,w10,w12,w14,w16,w18,w20,w22,w24,w26,w28,w30,w32,w34,w36,w38,w40,w42,w44,w46,w48,w50,w52 at 23:00'    
    runentry = scheduleparser.RunEntry(s)
    dialog = RunentryDialog(None,runentry) 
                            
    dialog.show()
    app.exec_()

