#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
from PyKDE4.kdecore import ki18n, KAboutData, KCmdLineArgs, KConfig
from PyKDE4.kdeui import KApplication
 
#import pprint
#pp = pprint.PrettyPrinter(indent=4)

def getFullName( config ):
  if config.name() == "<default>":
    return ""
  else:
    if config.parent():
      parentsNames = getFullName( config.parent() )
    return  parentsNames + "[" + config.name() + "]"

def dumpGroup( config ):
  print getFullName( config )
  for i in config.entryMap():
    print i + ": " + config.readEntry( i )
  print

def dumpSubGroups( config ):
  dumpGroup( config )
  #print dir( config )
  for i in config.groupList():
    configGroup=config.group(str(i))
    dumpSubGroups( configGroup )


appName     = "KApplication"
catalog     = ""
programName = ki18n ("KApplication")
version     = "1.0"
description = ki18n ("KApplication/KMainWindow/KAboutData example")
license     = KAboutData.License_GPL
copyright   = ki18n ("(c) 2009 Jörg Steffens")
text        = ki18n ("none")
homePage    = "www.dass-it.de"
bugEmail    = "rt@dass-it.de"
 
aboutData   = KAboutData (appName, catalog, programName, version, description,
                        license, copyright, text, homePage, bugEmail)
 
 
KCmdLineArgs.init (sys.argv, aboutData)
app = KApplication ()

config = KConfig("plasma-desktoprc")

for i in config.groupList():
  configGroup=config.groupImpl(str(i))
  dumpSubGroups( configGroup )
