#!/usr/bin/env python
# -*- coding: utf-8 -*-

usage = """Usage:
knotify-recipient.py

listens to knotify signals and prints them
"""

# see
#   http://cgit.freedesktop.org/dbus/dbus-python/tree/examples/example-signal-emitter.py
#   http://dbus.freedesktop.org/doc/dbus-python/doc/tutorial.html

import sys
import traceback

import gobject

import dbus
import dbus.mainloop.glib
#import dbus.mainloop.qt

def handle_reply(msg):
    print msg

def handle_error(e):
    print str(e)

def signal_handler_notificationClosed(id):
    print "handler_notificationClosed ", str(id)

def signal_handler_actionInvoked(id,action):
    print "handler_actionInvoked: ", str(id), ", ", str(action)


#def catchall_signal_handler(*args, **kwargs):
    #print ("Caught signal (in catchall handler) "
           #+ kwargs['dbus_interface'] + "." + kwargs['member'])
    #for arg in args:
        #print "        " + str(arg)

def catchall_hello_signals_handler(hello_string):
    print "Received a hello signal and it says ", hello_string
    
#def catchall_testservice_interface_handler(hello_string, dbus_message):
    #print "com.example.TestService interface says " + hello_string + " when it sent signal " + dbus_message.get_member()


if __name__ == '__main__':
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
    #dbus.mainloop.qt.DBusQtMainLoop(set_as_default=True)

    bus = dbus.SessionBus()
    try:
        object  = bus.get_object("org.kde.knotify", "/Notify")

        #object.connect_to_signal("notificationClosed", hello_signal_handler, dbus_interface="org.kde.knotify", arg0="Hello")
        object.connect_to_signal("notificationClosed", signal_handler_notificationClosed, dbus_interface="org.kde.KNotify")
        object.connect_to_signal("actionInvoked", signal_handler_actionInvoked, dbus_interface="org.kde.KNotify")
    except dbus.DBusException:
        traceback.print_exc()
        print usage
        sys.exit(1)

    #lets make a catchall
    #bus.add_signal_receiver(catchall_signal_handler, interface_keyword='dbus_interface', member_keyword='member')

    bus.add_signal_receiver(catchall_hello_signals_handler, dbus_interface = "org.kde.KNotify", signal_name = "notificationClosed")

    #bus.add_signal_receiver(catchall_testservice_interface_handler, dbus_interface = "com.example.TestService", message_keyword='dbus_message')

    loop = gobject.MainLoop()
    loop.run()
