#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
kreadconfig.py dumps KDE configuration files. 
It is usefull for debugging KDE Kiosks settings,
where multiple config files are merged into the final configuration.  

The directory hierarchie for config files 
is based on the KDEDIRS environment variable
and can be made visible by  the command
kde4-config --path config

kreadconfig has a similiar purpose,
but is limited to a single value
"""

# $Id: kreadconfig.py 791 2009-09-02 13:37:29Z joergs $

import sys
from PyKDE4.kdecore import ki18n, KAboutData, KCmdLineArgs, KConfig
from PyKDE4.kdeui import KApplication
 
#import pprint
#pp = pprint.PrettyPrinter(indent=4)

def getFullName( config ):
  if config.name() == "<default>":
    return ""
  else:
    if config.parent():
      parentsNames = getFullName( config.parent() )
    return  parentsNames + "[" + config.name() + "]"

def dumpGroup( config ):
  print getFullName( config )
  for i in config.entryMap():
    print i + ": " + config.readEntry( i )
  print

def dumpSubGroups( config ):
  dumpGroup( config )
  #print dir( config )
  for i in config.groupList():
    configGroup=config.group(str(i))
    dumpSubGroups( configGroup )


appName     = "KApplication"
catalog     = ""
programName = ki18n ("KApplication")
version     = "1.0"
description = ki18n ("KApplication/KMainWindow/KAboutData example")
license     = KAboutData.License_GPL
copyright   = ki18n ("(c) 2009 Jörg Steffens")
text        = ki18n ("none")
homePage    = "www.dass-it.de"
bugEmail    = "rt@dass-it.de"
 
aboutData   = KAboutData (appName, catalog, programName, version, description,
                        license, copyright, text, homePage, bugEmail)
 
 
KCmdLineArgs.init (sys.argv, aboutData)
app = KApplication ()

config = KConfig("plasma-desktoprc")

for i in config.groupList():
  configGroup=config.groupImpl(str(i))
  dumpSubGroups( configGroup )
