OBS Notify Plugin
=================


Installation
------------

The file `obs_notify_generic.pm` and `obs_notify_generic_config.pm` must be located in the 
`/usr/lib/obs/server/plugins/` directory.

Modify the OBS config file `/usr/lib/obs/server/BSConfig.pm`
and add/set

our $notification_plugin = "obs_notify_generic";

Alternativly you can create an host specific configuration file:

```
/usr/lib/obs/server/bsconfig.`hostname -f`
```

```
# notify settings
our $notification_plugin = "obs_notify_generic";

1;
```


Configuration
-------------

All configuration for this plugin is done in the file

```
/usr/lib/obs/server/plugins/obs_notify_generic_config.pm
```

The default log file is

```
/src/obs/log/notify_generic.log
```

but can be configured.

The starting configuration could look like this:

```
our $cfg     = {
    "UNKNOWN"            => [ { "log" => 1 } ],
}
```

This logs all UNKNOWN events. With this configuration this are all events, as no specific notification types are defined.

Usefull notification types are
  *  "BUILD_FAIL"
  *  "BUILD_SUCCESS"
  *  "REPO_PUBLISHED"

Each event come with a number of parameter. These will also be logged.

The configuration directive `filter` limits a notification type to certain cases. Filter can be regexes.

Example:

```
our $cfg     = {
    "REPO_PUBLISH_STATE" => [],
    "REPO_PUBLISHED"     => [
        {
            "filter" => { 'project' => '.*:bareos' },
            "log"    => 1,
        },
        {
            "filter" => { 'project' => '.*:bareos', 'repo' => 'SLE_12' },
            "action" => 'logger "project $project published for repository $repository',
            "log"    => 0,
        },
    ],
    "UNKNOWN"            => [ { "log" => 1 } ],
}
```

Meaning:
  * type=REPO_PUBLISH_STATE
    * ignore it
  * type=REPO_PUBLISHED:
    * log every time a project that matches the name ":bareos" get published
    * when the project is published for SLE_12, also create a syslog message

Limitations:
  * the `action` run as user obsrun. As the OBS service run as daemon, only very few environment variables are set. It might help to call scripts using `sudo -u USERNAME`
  * the `action` script do run in background, to prevent blocking other OBS services. Output will be write to `${logfile}.out.log`.
