#!/usr/bin/env python

# -*- coding: utf-8 -*-

"""ospi-client: performs operation for opsi clients on opsi server via JSON-RPC."""

__author__ = "Joerg Steffens"
__copyright__ = "Copyright 2012, dass IT GmbH"
__license__ = "GPL"
__version__ = "1.0"
__email__ = "joerg.steffens@dass-it.de"

# 
# Skript, dass ein OPSI-Rechner-Eintrag kopiert.
# D.h. die Produkte, Anforderung.
# Ggf. optional Stand und ggf. Versionsnummer
# Ggf. optional ProductProperties
#

import jsonrpc
from pprint import pprint

class OpsiRpc:
    
    
    ProductAttributesCopy = ['actionRequest','actionResult','installationStatus','packageVersion','productVersion']
    
    def __init__(self, urlJsonRpc, debug=False ):
        self.debug=debug
        self.urlJsonRpc=urlJsonRpc
        self.rpc=jsonrpc.ServiceProxy(self.urlJsonRpc)
        
    def dump(self):
        print self.urlJsonRpc
        print self.rpc.getClientIds_list()

    def list(self):
        return self.rpc.getClientIds_list()
        
    def exists(self, src):
        return len( self.rpc.host_getObjects( [], {"id":src} ) ) == 1
        
    def info(self, src):
        if not self.exists( src ):
            print "failed: opsi client", src, "does not exist"
            return False
        print src + ":"
        host = self.rpc.host_getHashes( [], {"id":src} )[0]
        print "  IP:", host["ipAddress"]
        print "  MAC:", host["hardwareAddress"]
        print "  inventory:", host["inventoryNumber"]
        print "  last seen:", host["lastSeen"]
        print "  notes:", host["notes"]
        
        print "  products:"
        products = self.getProductOnClient( src, [] )
        for i in products:
            print "    " + i['productId'] + ":"
            print "      " + i['installationStatus'], "(",
            if i['actionRequest']:
                print i['actionRequest'],
                if i['actionProgress']:
                    print i['actionProgress'],
            print ")"
            print "      ",
            pprint( i, indent=8 )
        return True

    def clean(self, src):
        if not self.exists( src ):
            return False
        products = self.rpc.productOnClient_getObjects( [], { 'clientId': src } )
        self.rpc.productOnClient_deleteObjects( products )
        if self.debug:
            pprint( self.getProductOnClient( src ) )
        return True
       
    def createClient(self, name, opsiHostKey, description, notes, hardwareAddress, ipAddress):
        self.rpc.host_createOpsiClient( name, opsiHostKey, description, notes, hardwareAddress, ipAddress )

    def clientSetDepot(self, name, depot):
        self.rpc.configState_create( "clientconfig.depot.id", name, depot )        

    def copyClient( self, src, dst, ipAddress = None, hardwareAddress = None, depot = None, description = "" ):
    
        print "create/update", dst, "from template", src + ":",
        #method host_createOpsiClient id *opsiHostKey *description *notes *hardwareAddress *ipAddress *inventoryNumber *oneTimePassword *created *lastSeen
        #id=dst
        opsiHostKey=None
        notes="copy of " + src
        self.createClient(dst, opsiHostKey, description, notes, hardwareAddress, ipAddress)
        if depot:
            self.clientSetDepot(dst,depot)
        if self.debug:
            pprint( self.getProductOnClient( src ) )
        self.copyProductOnClient( src, dst )
        # TODO: 
        #  copy product properties:
        #  opsiCallClientBaculaProperties=[ "method", "getProductProperties_hash", "bacula" ]
        print "done"
        return True

        
    def getProductOnClient( self, client, attributes = ProductAttributesCopy ):
        #pprint( self.rpc.productOnClient_getObjects( [], { 'clientId': client } ) )
        #pprint( self.rpc.productOnClient_getHashes( attributes, { 'clientId': client } ) )
        return self.rpc.productOnClient_getHashes( [], { 'clientId': client } )
        
    def copyProductOnClient( self, src, dst, attributes = ProductAttributesCopy ):
        products = self.rpc.productOnClient_getHashes( attributes, { 'clientId': src } )
        for i in products:
            if self.debug: 
                print i['productId']
                pprint( i )
            i['clientId'] = dst
            self.rpc.productOnClient_createObjects( i )
        if self.debug:
            pprint( self.getProductOnClient( dst ) )
