#
# spec file for package
#
# Copyright (c) 2013 dass IT GmbH, Cologne, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via packager@dass-it.de
#
# norootforbuild

Name:           wsusoffline
Group:          System/Management
Version:        8.0.0
%define ver     "80"
Release:        1
Summary:        WSUS Offline Update: download Microsoft updates
License:        GPLv2+
URL:            http://www.wsusoffline.net/
Source:         %{name}_%{version}.orig.tar.gz
#Source99:       #{name}-rpmlintrc
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  unzip

# for goupadd
%if 0%{?suse_version}
Requires(pre):  pwdutils
%else
#Requires(pre):  shadow-utils
Requires(pre):  /usr/bin/groupadd
%endif

Requires:       cabextract md5deep xmlstarlet wget
BuildArch:      noarch

%description
"WSUS Offline Update" allows you to download most Microsoft updates and store them localy.
This includes Windows, Office and some extensions like dotnet or Powershell.
After downloading, they can be installed on any Microsoft Windows system without an  Internet connection.
Also unattended/silient installation are possible, so the update be be included easily in a Windows software management system like http://www.opsi.org

%prep
%setup -c


%build



%install
%define DEST_DIR /var/lib/wsusoffline/
mkdir -p $RPM_BUILD_ROOT/var/lib/
unzip wsusoffline/%{name}%{ver}.zip -d $RPM_BUILD_ROOT/var/lib/
install -d $RPM_BUILD_ROOT/%{DEST_DIR}/temp/


# remove windows only stuff
rm -r $RPM_BUILD_ROOT/%{DEST_DIR}/*.exe
rm -r $RPM_BUILD_ROOT/%{DEST_DIR}/*.au3
rm -r $RPM_BUILD_ROOT/%{DEST_DIR}/bin
rm -r $RPM_BUILD_ROOT/%{DEST_DIR}/cmd

# adapt permissions
chmod g+ws $RPM_BUILD_ROOT/%{DEST_DIR}
find $RPM_BUILD_ROOT/%{DEST_DIR}/client/ -type d -exec chmod g+ws {} \;
chmod g+ws $RPM_BUILD_ROOT/%{DEST_DIR}/exclude/
chmod g+ws $RPM_BUILD_ROOT/%{DEST_DIR}/log/
chmod g+ws $RPM_BUILD_ROOT/%{DEST_DIR}/iso/
chmod g+ws $RPM_BUILD_ROOT/%{DEST_DIR}/sh/
chmod a+x  $RPM_BUILD_ROOT/%{DEST_DIR}/sh/*
chmod g+ws $RPM_BUILD_ROOT/%{DEST_DIR}/temp/


# install start wrapper scripts
mkdir -p $RPM_BUILD_ROOT/usr/bin/
install wsusoffline/*.sh $RPM_BUILD_ROOT/usr/bin/



%clean
rm -rf %{buildroot}

%pre
getent group wsusoffline >/dev/null || groupadd -r wsusoffline


%files
%defattr(-,root,root)
/usr/bin/wsus-*.sh
%dir %{DEST_DIR}
# #{DEST_DIR}/bin
# #{DEST_DIR}/cmd
%{DEST_DIR}/doc
%{DEST_DIR}/static
%{DEST_DIR}/xslt
 
%defattr(-,root,wsusoffline)
%{DEST_DIR}/client/
%{DEST_DIR}/exclude/
%{DEST_DIR}/iso/
%{DEST_DIR}/log/
%{DEST_DIR}/sh/
%{DEST_DIR}/temp/

%changelog
