#!/usr/bin/python26
###
### backmon.commands.summary.backups
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser
from guppy import hpy

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import bpstulist
from backup_monitoring.parsing.parsers import nbdevquery
from backup_monitoring.parsing.parsers import bpdbjobs

usage = 'usage: %prog -e environment status backups'

parser = OptionParser(usage=usage)
#parser.add_option('-s', '--include-staging', action='store_true', default=False, dest='include_staging', help='include staging storage units')

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    master_feeds    = ['nbemmcmd_machinealias_getaliases', 'bpdbjobs_most_columns']
    media_feeds     = [ ]

    try:

        environments = ENVIRONMENTS.values()

        hp = hpy()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        for environment in environments:
            environment.load_feeds(master=master_feeds, media=media_feeds)
            environment.parse_jobs()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        print('%s %s %s %s %s %s' % ('ENVIRONMENT'.center(15), 'ACTIVE'.center(6), 'QUEUED'.center(6), 'RETRYING'.center(8), 'SUSPENDED'.center(9), 'INCOMPLETE'.center(10)))
        print('=============== ====== ====== ======== ========= ==========')

        active      = 0
        queued      = 0
        retrying    = 0
        suspended   = 0
        incomplete  = 0
        foo         = 0

        for environment in environments:

            for job in environment.jobs:

                if job.active:
                    active += 1

                if job.queued:
                    queued += 1

                if job.state == 'wait for retry':
                    retrying += 1

                if job.state == 'suspended':
                    suspended += 1

                if job.state == 'incomplete':
                    incomplete += 1 

                if job.state in ['6', '7']:
                    foo += 1

            #
            # print backup status
            #
            print('%s %6d %6d %8d %9d %10d' % (environment.name.center(15), active, queued, retrying, suspended, incomplete))

    except Exception, e:

        raise

