#!/usr/bin/python26
###
### backmon.commands.check.scratch
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser
from guppy import hpy

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import vmpool
from backup_monitoring.parsing.parsers import vmquery
from backup_monitoring.parsing.parsers import bpmedialist

usage = 'usage: %prog -e [environment] check scratch [robot_number]'

parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    if len(args) == 0:
        ERROR('No robot number specified!')
        sys.exit(3)

    ROBOT_NUMBER = int(args[0])

    master_feeds    = ['nbemmcmd_machinealias_getaliases', 'vmpool', 'vmpool_list_scratch', 'vmquery', 'bpmedialist']
    media_feeds     = [ ]

    if not ENVIRONMENT:
        ERROR('Must specify backup environment!')
        sys.exit(1) 

    try:

        environment = ENVIRONMENTS[ENVIRONMENT]

        hp = hpy()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        volume_count = 0
        scratch_count = 0

        environment.load_feeds(master=master_feeds, media=media_feeds)
        environment.parse_pools()
        environment.parse_scratch()
        environment.parse_volumes()
        #environment.parse_media()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        for volume in environment.volumes:

            if volume.robot_number == ROBOT_NUMBER:

                volume_count += 1

                if volume.pool_name == environment.scratch_pool:

                    scratch_count += 1

        if scratch_count > 0 and volume_count > 0:
            pct_scratch = float(scratch_count) / float(volume_count) * 100.0
        else:
            pct_scratch = 0.0

        perfdata = 'scratch=%d%%;95;99;0;100' % (pct_scratch)
        print 'OK: %d scratch volumes out of %d in robot %d | %s' % (scratch_count, volume_count, ROBOT_NUMBER, perfdata)

    except Exception, e:

        raise

        #perfdata = 'scratch=0%;95;99;0;100'
        #print 'scratch volume monitoring data unavailable! | %s' % (perfdata)

