#!/usr/bin/python26
###
### backmon.commands.check.puredisk
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import puredisk_status

service_list = [
    'ldap_server',
    'vxatd_daemon',
    'memory_cache_daemon',
    'database_server',
    'web_server',
    'spa_authorization_service',
    'controller',
    'controller_monitor',
    'server_agent',
    'content_router',
    'workflow_engine',
    'metabase_engine',
    'java_gui',
    'cron_daemon',
]

usage = """usage: %prog -s [server] check puredisk [service]

  available services:

""" + '\n'.join(['  %s' % (service) for service in service_list])

parser = OptionParser(usage=usage)

SERVICE_NAMES = {

    'ldap_server'               :   'LDAP-server',
    'vxatd_daemon'              :   'VxATd daemon',
    'memory_cache_daemon'       :   'PureDisk Memory Cache Daemon',
    'database_server'           :   'PureDisk Database Server',
    'web_server'                :   'PureDisk WebServer',
    'spa_authorization_service' :   'PureDisk SPA Authorization Service',
    'controller'                :   'PureDisk Controller',
    'controller_monitor'        :   'PureDisk Controller Monitor',
    'server_agent'              :   'PureDisk Server Agent',
    'content_router'            :   'PureDisk ContentRouter',
    'workflow_engine'           :   'PureDisk Workflow Engine',
    'metabase_engine'           :   'PureDisk MetabaseEngine',
    'java_gui'                  :   'PureDisk JAVA GUI',
    'cron_daemon'               :   'CRON daemon',
    'test'                      :   'Test',

}

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    if len(args) == 0:
        ERROR('Must specify service!')
    else:
        SERVICE = args[0]

    if not SERVER:
        ERROR('Must specify puredisk server!')
        sys.exit(1) 

    if SERVICE not in SERVICE_NAMES:
        ERROR('Invalid service %s!' % (SERVICE))
        sys.exit(1) 

    else:

        updates = Updates(LOGGER, SERVER_PATH)

    try:

        SERVICE_NAME = SERVICE_NAMES[SERVICE]

        stream = puredisk_status.stream(updates.feed('puredisk_status'))
        status = puredisk_status.parse(stream.records()[0])
        perfdata = ''

        if SERVICE_NAME not in status:

            print('PureDisk service "%s" not found in monitoring data!' % (SERVICE_NAME))
            sys.exit(2)

        elif SERVICE_NAME in status:

            state = status[SERVICE_NAME]

            if state == 'running':

                print('OK: %s is running | %s' % (SERVICE_NAME, perfdata))
                sys.exit(0)

            else:

                print('%s is %s | %s' % (SERVICE_NAME, state, perfdata))
                sys.exit(2)

        else:

            print('Unknown error! | %s' % (perfdata))
            sys.exit(3)

    except Exception, e:

        raise

