
import __builtin__
import filelike

from ..dependencies.odict import OrderedDict

__all__ = [
    'adict',
    'fmt_pair',
    'StringAsFile',
    'ExtendedDict',
]


##
## Dictionary with attribute access
##
class adict(dict):

    def __init__(self, dict={}):
        self.update(dict)

    def __getattr__(self, name):
        if self.has_key(name):
            return self[name]
        else:
            raise AttributeError, 'Attribute \'%s\' does not exist in dictionary' % (name)

    def __setattr__(self, name, value):
        self[name] = value


##
## Extended Dictionary Class
##
#class ExtendedDict(dict):
#
#    def __init__(self, dict={}):
#        self.update(dict)
#
#    def __getattr__(self, name):
#        if self.has_key(name):
#            return self[name]
#        else:
#            raise AttributeError, 'Attribute \'%s\' does not exist in dictionary' % (name)
#
#    def __setattr__(self, name, value):
#        self[name] = value
#
#    def __iter__(self):
#        return iter(self.values())


##
## Extended Dictionary Class
##
#class ExtendedDict(object):
#
#    def __init__(self):
#        self.odict = OrderedDict()
#
#    def __getitem__(self, key):
#        return self.odict[key]
#
#    def __setitem__(self, key, value):
#        self.odict[key] = value
#
#    def __getattr__(self, name):
#        if name in self.odict:
#            return self.odict[name]
#        else:
#            raise AttributeError, 'Attribute \'%s\' does not exist in dictionary' % (name)
#
#    def __setattr__(self, name, value):
#        if name in self.odict:
#            pass
#        else:
#            object.__setattr__(self, name, value)
#
#    def __iter__(self):
#        return self.odict.__iter__()
#
#    def keys(self):
#        return self.odict.keys()


##
## Extended Dictionary Class
##
## INSPIRATION: http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/389916
##
class ExtendedDict(OrderedDict):

    def __init__(self, attribute=None, *args, **kwargs):

        OrderedDict.__init__(self, *args, **kwargs)

    def __getattr__(self, name):

        if self.__dict__.has_key(name):
            return OrderedDict.__getattr__(self, name)
        else:
            try:
                return self.__getitem__(name)
            except KeyError:
                raise AttributeError(name)

    def __setattr__(self, name, value):

        #if self.__dict__.has_key(name):
        #    return OrderedDict.__setattr__(self, name, value)
        #else:
        #    return OrderedDict.__setitem__(self, name, value)

        if self.has_key(name):
            return OrderedDict.__setitem__(self, name, value)
        else:
            return OrderedDict.__setattr__(self, name, value)

    def __delattr__(self, name):

        if self.has_key(name):
            return OrderedDict.__delitem__(self, name)
        else:
            return OrderedDict.__delattr__(self, name)

    def __iter__(self):

        return OrderedDict.itervalues(self)


##
## Pretty print name / value pairs as name...: value.
##
def fmt_pair(name, value, width=25):
    ln = len(name)
    dotcount = 0
    if ln <= width:
        dotcount = width - ln
    return '%s%s: %s' % (name, '.' * dotcount, value)


##
## String filelike object
##
class StringAsFile(filelike.FileLikeBase):

    def __init__(self,string):
        filelike.FileLikeBase.__init__(self)
        self._string = string
        self._pos = 0

    def _read(self,sizehint=-1):
        if self._pos >= len(self._string):
            return None
        if sizehint < 0:
            newPos = len(self._string)
        else:
            newPos = min(self._pos + sizehint,len(self._string))
        data = self._string[self._pos:newPos]
        self._pos  = newPos
        return data


##
## Add our builtins to the builtin namespace
##
for name in __all__:
    exec 'setattr(__builtin__, name, %s)' % (name)
