import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## df has one record per-line
##
def stream(stream, format='df -k'):

    if format in ['df -k']:
        return NewLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a df record
##
##     df -k
##
def parse(record, format='df -k', version=None, tz=None):

    fs = ExtendedDict()

    if format == 'df -k':

        regex = re.compile('^(\S+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)%\s+(\S+).*$')

        try:

            match = regex.match(record)

            fs['device']        = match.group(1)
            fs['kbytes']        = long(match.group(2))
            fs['used']          = long(match.group(3))
            fs['avail']         = long(match.group(4))
            fs['pct_full']      = int(match.group(5))
            fs['mountpoint']    = match.group(6)

            return fs

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
