import re

import time
import datetime
import pytz

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...autotype import *
from ...streams import *

##
## nbemmcmd feeds have records separated by blank lines
##
def stream(stream, format='nbemmcmd -machinealias -getaliases'):

    if format in ['nbemmcmd -machinealias -getaliases']:
        return BlankLineStream(stream, header=0)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a nbemmcmd record
##
##     nbemmcmd -L
##
def parse(record, format='nbemmcmd -machinealias -getaliases', version=None, tz=None):

    if format == 'nbemmcmd -machinealias -getaliases':

        aliases = []

        try:

            #
            # strip header
            #
            #     NBEMMCMD, Version:6.5.4
            #
            record.pop(0)

            #
            # get alias name
            #
            try:
                alias = re.compile('^The following aliases were found for the alias: "(.+)"$').match(record.pop(0)).group(1)
            except:
                raise ParseError, 'No alias name found on line 2 of record!'

            for line in record:

                if line == 'Command completed successfully.':
                    continue

                aliases.append(line)

            return alias, aliases

        except Exception, e:

            for line in record:
                print line

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

