import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## bpgetconfig has one record per-stream
##
def stream(stream, format='bpgetconfig -X'):

    if format in ['bpgetconfig -X', 'bpgetconfig -L']:
        return SingleRecordStream(stream)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bpgetconfig record
##
##     bpgetconfig -X
##     bpgetconfig -L
##
def parse(record, format='bpgetconfig -X', version=None, tz=None):

    config = ExtendedDict()

    config['servers'] = []
    config['excludes'] = []

    if format in ['bpgetconfig -X', 'bpgetconfig -L']:

        try:

            for line in record:
                pair = line.split(' = ')            # pairs are delimited with =
                key = pair[0]
                if len(pair) == 2:                  # check if value exists
                    value = pair[1]
                    if re_integer.match(value):     # convert to integer if possible
                        value = int(value)
                else:
                    value = None                    # use None for no value
                config[key] = value                 # store under the original key name
                key = key.lower()                   # lowercase the key name
                key = key.replace(' ', '_')         # replace spaces with underscores
                key = key.replace('/', '_')         # replace slashes with underscores
                config[key] = value                 # store under the new key name

                if key == 'server':
                    config.servers.append(value)

                if key == 'exclude':
                    config.excludes.append(value)

            return config

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
