import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## bpretlevel has one record per-line
##
def stream(stream, format='bpretlevel -L'):

    if format in ['bpretlevel -L']:
        return NewLineStream(stream, header=4)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bpretlevel record
##
##     bpretlevel -L
##
def parse(record, format='bpretlevel -L', version=None, tz=None):

    retlevel = ExtendedDict()

    if format == 'bpretlevel -L':

        regex = re.compile('^\s+(\d+)\s+(\d+)\s+\(\s*(\d+)\)\s+(.*)$')

        try:

            match = regex.match(record)

            retlevel['retention_level']     = int(match.group(1))
            retlevel['equivalent_days']     = int(match.group(2))
            retlevel['retention_seconds']   = int(match.group(3))
            retlevel['retention_period']    = match.group(4).rstrip()

            return retlevel

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
