###
### Common Regular Expressions
###
import re

##
## Match a decimal integer
##
re_integer = re.compile('^\d+$')

##
## Match a floating point value
##
re_float = re.compile('^\d+\.\d+$')

##
## Scientific E Notation
##
##     +4.57087000000000E+002
##
re_enotation = re.compile('^([+-])?(\d+)\.(\d+)[eE]([+-])(\d+)$')

##
## SQL DATETIME
##
re_sql_datetime = re.compile('^(\d\d\d\d)-(\d\d)-(\d\d) (\d\d):(\d\d):(\d\d)\.?(\d*)$')
