import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

re_cannot_connect_on_socket = re.compile('^cannot connect on socket.*$')

##
## bpplclients has one record per-line
##
def stream(stream, format='bpplclients -L'):

    if format in ['bpplclients -L']:
        return NewLineStream(stream, header=0)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bpplclients record
##
##     bpplclients -allunique -L
##
def parse(record, format='bpplclients -L', version=None, tz=None):

    client = ExtendedDict()

    if format == 'bpplclients -L':

        if re_cannot_connect_on_socket.match(record):
            return None

        regex = re.compile('^Client/HW/OS/Pri:\s+(\S+)\s+(\S+)\s+(\S+)\s+(-?\d+)\s+(-?\d+)\s+(-?\d+)\s+(-?\d+)\s+(\S+)$')

        try:

            match = regex.match(record)

            client['client']    = match.group(1)
            client['name']      = match.group(1)
            client['hw']        = match.group(2)
            client['os']        = match.group(3)
            client['pri']       = int(match.group(4))

            return client

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
