import re

import time
import datetime
import pytz

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...autotype import *
from ...streams import *

##
## dsu_ls_l has records separated by blank lines
##
def stream(stream, format='dsu_ls_l'):

    if format in ['dsu_ls_l']:
        return BlankLineStream(stream, header=0)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a dsu_ls_l record
##
def parse(record, format='dsu_ls_l', version=None, tz=None):

    if format == 'dsu_ls_l':

        try:

            dir = adict()

            expression = re.compile('^(\S+)\s+(\d+)\s+(\S+)\s+(\S+)\s+(\d+)\s+([a-zA-Z]{3})\s+([0-9]+)\s+([0-9:]+)\s+(\S+).*$')

            path = record.pop(0)
            total = long(record.pop(0).split(' ')[1])

            dir.path = path
            dir.total = total
            dir.files = ExtendedDict()

            for line in record:

                #
                # skip non regular files
                #
                if( list(line)[0] != '-'):
                    continue

                match = expression.match(line)

                file = ExtendedDict()

                if match:

                    mode        = match.group(1)
                    links       = int(match.group(2))
                    owner       = match.group(3)
                    group       = match.group(4)
                    size        = int(match.group(5))
                    filename    = match.group(9)

                    #print('mode=%s, links=%d, owner=%s, group=%s, size=%d, filename=%s'  % (mode, links, owner, group, size, filename))

                    file.mode       = mode
                    file.links      = int(links)
                    file.owner      = owner
                    file.group      = group
                    file.size       = long(size)
                    file.filename   = filename

                    dir.files[filename] = file

                else:

                    raise ParseError, 'could not parse line: %s' % (line)

            return dir

        except Exception, e:

            for line in record:
                print line

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

