#!/usr/bin/python26
###
### backmon.commands.feed
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser

from ..lib import *

usage = 'usage: %prog -s server feed [feed]'

parser = OptionParser(usage=usage)

parser.add_option('-l', '--lock', action='store_true', dest='lock', default=False, help='lock matching feeds')

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    if not OPTIONS.server:
        ERROR('Please specify a server to use the feed command.')
        sys.exit(1)
    elif( len(args) == 0 ):
        ERROR('No feed specified.')
        sys.exit(1)
    else:
        feed = args.pop(0)
        DEBUG('FEED=%s' % (feed))
        updates = Updates(LOGGER, SERVER_PATH)

        filename = '%s.txt' % (feed)
        file = updates.open(filename)
        
        if file is not None:
            for line in file:
                sys.stdout.write(line)
            updates.close(filename)
        else:
            ERROR('Could not access file %s!' % (filename))

