import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

re_status = re.compile('^Checking for (.*) \.\.(.*)$')

##
## puredisk status has one record per-stream
##
def stream(stream, format='puredisk status'):

    if format in ['puredisk status']:
        return SingleRecordStream(stream)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a puredisk status record
##
##     /etc/init.d/puredisk status
##
def parse(record, format='puredisk status', version=None, tz=None):

    status = ExtendedDict()

    if format in ['puredisk status']:

        try:

            for line in record:

                match = re_status.match(line)

                if match:

                    service = match.group(1)
                    state = match.group(2)

                    status[service] = state

            return status

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
