#!/usr/bin/python26
###
### backmon.commands.status.filesystem
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser

from ....lib import *

from backup_monitoring.parsing.parsers import df

usage = 'usage: %prog -s server status filesystem [filesystem]'

parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    if not OPTIONS.server:
        ERROR('Please specify a server to use the status fileystem command.')
        sys.exit(1)
    elif( len(args) == 0 ):
        ERROR('No filesystem specified.')
        sys.exit(1)
    else:
        filesystem = args.pop(0)
        filesystems = {}
        DEBUG('FILESYSTEM=%s' % (filesystem))
        updates = Updates(LOGGER, SERVER_PATH)

        try:

            stream = df.stream(updates.feed('df'))

            for record in stream:
                dfk = df.parse(record, format='df -k')
                mountpoint = dfk['mountpoint']
                filesystems[mountpoint] = dfk

            if filesystem in filesystems:
                print('filesystem=%(mountpoint)s, pct_full=%(pct_full)s' % filesystems[filesystem])
            else:
                ERROR('Could not locate filesystem %s on server %s!' % (filesystem, SERVER))

        except Exception, e:
            raise BackmonError, e

