#!/usr/bin/python26
###
### backmon.commands.mail.morning_report
###

import sys
import os
import os.path
import glob
import re
import email
import StringIO
import io
import mimetypes
import socket
import time
import datetime

from subprocess import *
from optparse import OptionParser
from guppy import hpy

from email import encoders
from email.message import Message
from email.mime.audio import MIMEAudio
from email.mime.base import MIMEBase
from email.mime.image import MIMEImage
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import bpstulist
from backup_monitoring.parsing.parsers import df
from backup_monitoring.parsing.parsers import dsu_ls_l
from backup_monitoring.parsing.parsers import nbstlutil
from backup_monitoring.parsing.parsers import nbdevquery
from backup_monitoring.parsing.parsers import bpdbjobs

usage = 'usage: %prog mail morning_report'
parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    #
    # query nagios
    #
    query = 'GET hosts\n'
    live = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    live.connect(SOCKET_PATH)
    live.send(query)
    live.shutdown(socket.SHUT_WR)

    HOST_COUNTS = ExtendedDict()
    HOST_COUNTS[None] = 0

    CRITICAL_COUNTS = ExtendedDict()
    CRITICAL_COUNTS[None] = 0

    WARNING_COUNTS = ExtendedDict()
    WARNING_COUNTS[None] = 0

    CRITICAL_HOSTS = ExtendedDict()
    CRITICAL_HOSTS[None] = []

    WARNING_HOSTS = ExtendedDict()
    WARNING_HOSTS[None] = []

    PROBLEM_STATES = ExtendedDict()
    PROBLEM_NOTES = ExtendedDict()

    environment_hostgroups = ExtendedDict()
    hostgroup_environments = ExtendedDict()

    for environment in CONFIG['ENVIRONMENTS']:

        HOST_COUNTS[environment] = 0
        CRITICAL_COUNTS[environment] = 0
        WARNING_COUNTS[environment] = 0
        CRITICAL_HOSTS[environment] = []
        WARNING_HOSTS[environment] = []

        hostgroup = CONFIG['ENVIRONMENTS'][environment]['hostgroup']

        environment_hostgroups[environment] = hostgroup
        hostgroup_environments[hostgroup] = environment

    response = [ line.split(';') for line in live.recv(100000000).split('\n')[:-1] ]

    columns = response[0]

    total_systems = 0
    problem_systems = 0

    for row in response[1:]:

        i = 0

        total_systems += 1

        host = ExtendedDict()

        for column in columns:

            #print '%s%s: %s' % (column, '.' * (30 - len(column)), row[i])
            host[column] = row[i]

            i += 1

        environment = None

        for hostgroup in host.groups.split(','):
            if hostgroup in hostgroup_environments:
                environment = hostgroup_environments[hostgroup]

        HOST_COUNTS[environment] += 1

        if host.state != '0' or host.num_services_crit != '0':
                
            problem_systems += 1
            CRITICAL_COUNTS[environment] += 1
            CRITICAL_HOSTS[environment].append(host.alias)
            PROBLEM_NOTES[host.alias] = host.notes
            print '%s:%s:%s' % (host.name, host.state, host.worst_service_state)

        elif host.worst_service_state == '1':

            problem_systems += 1
            WARNING_COUNTS[environment] += 1
            WARNING_HOSTS[environment].append(host.alias)
            PROBLEM_NOTES[host.alias] = host.notes
            print '%s:%s:%s' % (host.name, host.state, host.worst_service_state)

    print 'problem_systems = %s / %s' % (problem_systems, total_systems) 

    problem_summary_rows = ''
    
    for environment in CONFIG['ENVIRONMENTS']:

        print '%s problems = %s / %s / %s' % (environment, CRITICAL_COUNTS[environment], WARNING_COUNTS[environment], HOST_COUNTS[environment]) 

        problem_summary_rows += "            <tr><td>%s</td><td>%s</td><td>%s</td></tr>\n" % (environment, CRITICAL_COUNTS[environment], WARNING_COUNTS[environment])
        
    critical_detail_rows = ''
    
    for environment in CONFIG['ENVIRONMENTS']:

        for host in CRITICAL_HOSTS[environment]:

            print '%s (%s)' % (host, environment)

            critical_detail_rows += "            <tr><td>%s</td><td>%s</td><td>%s</td></tr>\n" % (environment, host, PROBLEM_NOTES[host])
        
    warning_detail_rows = ''
    
    for environment in CONFIG['ENVIRONMENTS']:

        for host in WARNING_HOSTS[environment]:

            print '%s (%s)' % (host, environment)

            warning_detail_rows += "            <tr><td>%s</td><td>%s</td><td>%s</td></tr>\n" % (environment, host, PROBLEM_NOTES[host])
        
    #time.sleep(10)

    #
    # generate email
    #
    IMG_PATH = os.path.join(CONFIG['HOME'], 'img', 'blackberry')
    DEBUG('IMG_PATH = %s' % (IMG_PATH))

    body = StringIO.StringIO()

    msg = MIMEMultipart('related')
    msg.preamble = 'This is a multi-part message in MIME format.'

    msg['To'] = TO
    msg['From'] = FROM
    #msg['Subject'] = 'Morning Report for %s' % (NOW.strftime('%d.%m.%Y'))
    #msg['Subject'] = 'Morning Report for %s' % (NOW.strftime('%a, %B %d'))
    msg['Subject'] = 'Data Backup Morning Report'
    msg['CC'] = CC
    msg['BCC'] = BCC

    alternative = MIMEMultipart('alternative')
    msg.attach(alternative)

    text = 'This message requires an email client that understands HTML.'
    alternative.attach(MIMEText(text, 'plain'))

    html = """
        <style type="text/css">

        h1
        {
            font-size:          19px;
            font-family:        arial,sans-serif;
        }

        table
        {
            table-layout:       auto;
            border:             1px solid #005AB0;
            border-collapse:    collapse;
            font-family:        arial,sans-serif;
            font-size:          19px;
            font-weight:        normal;
        }

        th, td
        {
            border:             1px solid #005AB0;
            padding:            3px;
        }

        </style>

        <html>
        <head></head>
        <body>
        <table width="100%%">
        <thead>
            <tr>
                <th colspan="3"><h1>Problem Summary</h1></th>
            </tr>
            <tr>
                <th colspan="1" width="33%%">Environment</th>
                <th colspan="1" width="33%%">Critical</th>
                <th colspan="1" width="33%%">Warning</th>
            </tr>
        </thead>
        <tbody>
%s        </tbody>
        <tfoot>
        </tfoot>
        </table>
        <br>
        <table width="100%%">
        <thead>
            <tr>
                <th colspan="3"><h1>Critical Detail</h1></th>
            </tr>
            <tr>
                <th colspan="1" width="33%%">Environment</th>
                <th colspan="1" width="33%%">Host</th>
                <th colspan="1" width="33%%">Notes</th>
            </tr>
        </thead>
        <tbody>
%s        </tbody>
        <tfoot>
        </tfoot>
        </table>
        <br>
        <table width="100%%">
        <thead>
            <tr>
                <th colspan="3"><h1>Warning Detail</h1></th>
            </tr>
            <tr>
                <th colspan="1" width="33%%">Environment</th>
                <th colspan="1" width="33%%">Host</th>
                <th colspan="1" width="33%%">Notes</th>
            </tr>
        </thead>
        <tbody>
%s        </tbody>
        <tfoot>
        </tfoot>
        </table>
        </body>
        </html>
    """ % (problem_summary_rows, critical_detail_rows, warning_detail_rows)

    #alternative.attach(MIMEText(html, 'html'))

    html_wrapper = """
        <style type="text/css">
        em
        {
            background-color:   #FFFFFF;
            color:              #FFFFFF;
        }

        </style>
        <html>
        <img src="cid:html.jpg" width="470">
        <br>
        <em>_</em>
        </html>
    """

    alternative.attach(MIMEText(html_wrapper, 'html'))

    #print msg

    wkhtmltoimage = Popen('/usr/bin/wkhtmltoimage -f jpg --width 470 - -', shell=True, bufsize=0, stdin=PIPE, stdout=PIPE, stderr=PIPE, close_fds=True)

    wkhtmltoimage_stdin = wkhtmltoimage.stdin
    wkhtmltoimage_stdin.write(html)
    wkhtmltoimage_stdin.close()

    wkhtmltoimage_stdout = wkhtmltoimage.stdout
    img = MIMEImage(wkhtmltoimage_stdout.read())
    wkhtmltoimage_stdout.close()
    img.add_header('Content-ID', 'html.jpg')
    msg.attach(img)

    for graphic in ['hr_yellow.jpg',]:

        fp = open(os.path.join(IMG_PATH, graphic), 'rb')
        img = MIMEImage(fp.read())
        fp.close() 
        img.add_header('Content-ID', '<%s>' % (graphic))
        #msg.attach(img)

    #print msg
    
    msmtp = os.popen('/usr/bin/msmtp --read-envelope-from --read-recipients', 'w')
    msmtp.write(msg.as_string())
    msmtp.close()

