###
### backmon.lib.locking
###
import os
import os.path
import time

from .exceptions import BackmonError

#
# lock() - Lock a file using lock directory semantics
#
def lock(path, retries=1, sleep=1):

    lock_dir = '%s.lock' % (path)

    for i in range(retries):
        try:
            os.mkdir(lock_dir)
            return True
        except OSError:
            time.sleep(sleep)

    return False


#
# unlock() - Unlock a file using lock directory semantics
#
def unlock(path, retries=1, sleep=1):

    lock_dir = '%s.lock' % (path)

    for i in range(retries):
        try:
            os.rmdir(lock_dir)
            return True
        except OSError:
            time.sleep(sleep)

    return False

