###
### Binary Unit Conversions
###
### --PLB 3/21/2003
###

##
## http://physics.nist.gov/cuu/Units/binary.html
##
## Factor  Name  Symbol        Origin          Derivation 
## ------  ----  ------  -------------------  -------------
## 2^10    kibi    Ki    kilobinary: (2^10)1  kilo: (10^3)1
## 2^20    mebi    Mi    megabinary: (2^10)2  mega: (10^3)2
## 2^30    gibi    Gi    gigabinary: (2^10)3  giga: (10^3)3
## 2^40    tebi    Ti    terabinary: (2^10)4  tera: (10^3)4
## 2^50    pebi    Pi    petabinary: (2^10)5  peta: (10^3)5
## 2^60    exbi    Ei    exabinary:  (2^10)6  exa:  (10^3)
##

##
## Bit Conversions
##
def bits_to_bits(n):
        return n

def bits_to_bytes(n):
        return n / 8.0

def bits_to_kibibytes(n):
        return n / 8192.0

def bits_to_kilobytes(n):
        return n / 8000.0

def bits_to_mebibytes(n):
        return n / 8388608.0

def bits_to_megabytes(n):
        return n / 8000000.0

def bits_to_gibibytes(n):
        return n / 8589934592.0

def bits_to_gigabytes(n):
        return n / 8000000000.0

def bits_to_tebibytes(n):
        return n / 8796093022208.0

def bits_to_terabytes(n):
        return n / 8000000000000.0

def bits_to_pebibytes(n):
        return n / 9007199254740992.0

def bits_to_petabytes(n):
        return n / 8000000000000000.0

def bits_to_exbibytes(n):
        return n / 9223372036854775808.0

def bits_to_exabytes(n):
        return n / 8000000000000000000.0

##
## Byte Conversions
##
def bytes_to_bits(n):
        return n * 8.0

def bytes_to_bytes(n):
        return n

def bytes_to_kibibytes(n):
        return n / 1024.0

def bytes_to_kilobytes(n):
        return n / 1000.0

def bytes_to_mebibytes(n):
        return n / 1048576.0

def bytes_to_megabytes(n):
        return n / 1000000.0

def bytes_to_gibibytes(n):
        return n / 1073741824.0

def bytes_to_gigabytes(n):
        return n / 1000000000.0

def bytes_to_tebibytes(n):
        return n / 1099511627776.0

def bytes_to_terabytes(n):
        return n / 1000000000000.0

def bytes_to_pebibytes(n):
        return n / 1125899906842624.0

def bytes_to_petabytes(n):
        return n / 1000000000000000.0

def bytes_to_exbibytes(n):
        return n / 1152921504606846976.0

def bytes_to_exabytes(n):
        return n / 1000000000000000000.0

##
## Kibibyte Conversions
##
def kibibytes_to_bits(n):
        return n * 8192.0

def kibibytes_to_bytes(n):
        return n * 1024.0

def kibibytes_to_kibibytes(n):
        return n

def kibibytes_to_kilobytes(n):
        return bytes_to_kilobytes(kibibytes_to_bytes(n))

def kibibytes_to_mebibytes(n):
        return bytes_to_mebibytes(kibibytes_to_bytes(n))

def kibibytes_to_megabytes(n):
        return bytes_to_megabytes(kibibytes_to_bytes(n))

def kibibytes_to_gibibytes(n):
        return bytes_to_gibibytes(kibibytes_to_bytes(n))

def kibibytes_to_gigabytes(n):
        return bytes_to_gigabytes(kibibytes_to_bytes(n))

def kibibytes_to_tebibytes(n):
        return bytes_to_tebibytes(kibibytes_to_bytes(n))

def kibibytes_to_terabytes(n):
        return bytes_to_terabytes(kibibytes_to_bytes(n))

def kibibytes_to_pebibytes(n):
        return bytes_to_pebibytes(kibibytes_to_bytes(n))

def kibibytes_to_petabytes(n):
        return bytes_to_petabytes(kibibytes_to_bytes(n))

def kibibytes_to_exbibytes(n):
        return bytes_to_exbibytes(kibibytes_to_bytes(n))

def kibibytes_to_exabytes(n):
        return bytes_to_exabytes(kibibytes_to_bytes(n))

##
## Kilobyte Conversions
##

def kilobytes_to_bits(n):
        return n * 8000.0

def kilobytes_to_bytes(n):
        return n * 1000.0

def kilobytes_to_kibibytes(n):
        return bytes_to_kibibytes(kilobytes_to_bytes(n))

def kilobytes_to_kilobytes(n):
        return n

def kilobytes_to_mebibytes(n):
        return bytes_to_mebibytes(kilobytes_to_bytes(n))

def kilobytes_to_megabytes(n):
        return bytes_to_megabytes(kilobytes_to_bytes(n))

def kilobytes_to_gibibytes(n):
        return bytes_to_gibibytes(kilobytes_to_bytes(n))

def kilobytes_to_gigabytes(n):
        return bytes_to_gigabytes(kilobytes_to_bytes(n))

def kilobytes_to_tebibytes(n):
        return bytes_to_tebibytes(kilobytes_to_bytes(n))

def kilobytes_to_terabytes(n):
        return bytes_to_terabytes(kilobytes_to_bytes(n))

def kilobytes_to_pebibytes(n):
        return bytes_to_pebibytes(kilobytes_to_bytes(n))

def kilobytes_to_petabytes(n):
        return bytes_to_petabytes(kilobytes_to_bytes(n))

def kilobytes_to_exbibytes(n):
        return bytes_to_exbibytes(kilobytes_to_bytes(n))

def kilobytes_to_exabytes(n):
        return bytes_to_exabytes(kilobytes_to_bytes(n))

##
## Mebibyte Conversions
##
def mebibytes_to_bits(n):
        return n * 8388608.0

def mebibytes_to_bytes(n):
        return n * 1048576.0

def mebibytes_to_kibibytes(n):
        return bytes_to_kibibytes(mebibytes_to_bytes(n))

def mebibytes_to_kilobytes(n):
        return bytes_to_kilobytes(mebibytes_to_bytes(n))

def mebibytes_to_mebibytes(n):
        return n

def mebibytes_to_megabytes(n):
        return bytes_to_megabytes(mebibytes_to_bytes(n))

def mebibytes_to_gibibytes(n):
        return bytes_to_gibibytes(mebibytes_to_bytes(n))

def mebibytes_to_gigabytes(n):
        return bytes_to_gigabytes(mebibytes_to_bytes(n))

def mebibytes_to_tebibytes(n):
        return bytes_to_tebibytes(mebibytes_to_bytes(n))

def mebibytes_to_terabytes(n):
        return bytes_to_terabytes(mebibytes_to_bytes(n))

def mebibytes_to_pebibytes(n):
        return bytes_to_pebibytes(mebibytes_to_bytes(n))

def mebibytes_to_petabytes(n):
        return bytes_to_petabytes(mebibytes_to_bytes(n))

def mebibytes_to_exbibytes(n):
        return bytes_to_exbibytes(mebibytes_to_bytes(n))

def mebibytes_to_exabytes(n):
        return bytes_to_exabytes(mebibytes_to_bytes(n))

##
## Megabyte Conversions
##
def megabytes_to_bits(n):
        return n * 8000000.0

def megabytes_to_bytes(n):
        return n * 1000000.0

def megabytes_to_kibibytes(n):
        return bytes_to_kibibytes(megabytes_to_bytes(n))

def megabytes_to_kilobytes(n):
        return bytes_to_kilobytes(megabytes_to_bytes(n))

def megabytes_to_mebibytes(n):
        return bytes_to_mebibytes(megabytes_to_bytes(n))

def megabytes_to_megabytes(n):
        return n

def megabytes_to_gibibytes(n):
        return bytes_to_gibibytes(megabytes_to_bytes(n))

def megabytes_to_gigabytes(n):
        return bytes_to_gigabytes(megabytes_to_bytes(n))

def megabytes_to_tebibytes(n):
        return bytes_to_tebibytes(megabytes_to_bytes(n))

def megabytes_to_terabytes(n):
        return bytes_to_terabytes(megabytes_to_bytes(n))

def megabytes_to_pebibytes(n):
        return bytes_to_pebibytes(megabytes_to_bytes(n))

def megabytes_to_petabytes(n):
        return bytes_to_petabytes(megabytes_to_bytes(n))

def megabytes_to_exbibytes(n):
        return bytes_to_exbibytes(megabytes_to_bytes(n))

def megabytes_to_exabytes(n):
        return bytes_to_exabytes(megabytes_to_bytes(n))

##
## Gibibytes Conversions
##
def gibibytes_to_bits(n):
        return n * 8589934592.0

def gibibytes_to_bytes(n):
        return n * 1073741824.0

def gibibytes_to_kibibytes(n):
        return bytes_to_kibibytes(gibibytes_to_bytes(n))

def gibibytes_to_kilobytes(n):
        return bytes_to_kilobytes(gibibytes_to_bytes(n))

def gibibytes_to_mebibytes(n):
        return bytes_to_mebibytes(gibibytes_to_bytes(n))

def gibibytes_to_megabytes(n):
        return bytes_to_megabytes(gibibytes_to_bytes(n))

def gibibytes_to_gibibytes(n):
        return n

def gibibytes_to_gigabytes(n):
        return bytes_to_gigabytes(gibibytes_to_bytes(n))

def gibibytes_to_tebibytes(n):
        return bytes_to_tebibytes(gibibytes_to_bytes(n))

def gibibytes_to_terabytes(n):
        return bytes_to_terabytes(gibibytes_to_bytes(n))

def gibibytes_to_pebibytes(n):
        return bytes_to_pebibytes(gibibytes_to_bytes(n))

def gibibytes_to_petabytes(n):
        return bytes_to_petabytes(gibibytes_to_bytes(n))

def gibibytes_to_exbibytes(n):
        return bytes_to_exbibytes(gibibytes_to_bytes(n))

def gibibytes_to_exabytes(n):
        return bytes_to_exabytes(gibibytes_to_bytes(n))

##
## Gigabyte Conversions
##
def gigabytes_to_bits(n):
        return n * 8000000000.0

def gigabytes_to_bytes(n):
        return n * 1000000000.0

def gigabytes_to_kibibytes(n):
        return bytes_to_kibibytes(gigabytes_to_bytes(n))

def gigabytes_to_kilobytes(n):
        return bytes_to_kilobytes(gigabytes_to_bytes(n))

def gigabytes_to_mebibytes(n):
        return bytes_to_mebibytes(gigabytes_to_bytes(n))

def gigabytes_to_megabytes(n):
        return bytes_to_megabytes(gigabytes_to_bytes(n))

def gigabytes_to_gibibytes(n):
        return bytes_to_gibibytes(gigabytes_to_bytes(n))

def gigabytes_to_gigabytes(n):
        return n

def gigabytes_to_tebibytes(n):
        return bytes_to_tebibytes(gigabytes_to_bytes(n))

def gigabytes_to_terabytes(n):
        return bytes_to_terabytes(gigabytes_to_bytes(n))

def gigabytes_to_pebibytes(n):
        return bytes_to_pebibytes(gigabytes_to_bytes(n))

def gigabytes_to_petabytes(n):
        return bytes_to_petabytes(gigabytes_to_bytes(n))

def gigabytes_to_exbibytes(n):
        return bytes_to_exbibytes(gigabytes_to_bytes(n))

def gigabytes_to_exabytes(n):
        return bytes_to_exabytes(gigabytes_to_bytes(n))

##
## Tebibyte Conversions
##
def tebibytes_to_bits(n):
        return n * 8796093022208.0

def tebibytes_to_bytes(n):
        return n * 1099511627776.0

def tebibytes_to_kibibytes(n):
        return bytes_to_kibibytes(tebibytes_to_bytes(n))

def tebibytes_to_kilobytes(n):
        return bytes_to_kilobytes(tebibytes_to_bytes(n))

def tebibytes_to_mebibytes(n):
        return bytes_to_mebibytes(tebibytes_to_bytes(n))

def tebibytes_to_megabytes(n):
        return bytes_to_megabytes(tebibytes_to_bytes(n))

def tebibytes_to_gibibytes(n):
        return bytes_to_gibibytes(tebibytes_to_bytes(n))

def tebibytes_to_gigabytes(n):
        return bytes_to_gigabytes(tebibytes_to_bytes(n))

def tebibytes_to_tebibytes(n):
        return n

def tebibytes_to_terabytes(n):
        return bytes_to_terabytes(tebibytes_to_bytes(n))

def tebibytes_to_pebibytes(n):
        return bytes_to_pebibytes(tebibytes_to_bytes(n))

def tebibytes_to_petabytes(n):
        return bytes_to_petabytes(tebibytes_to_bytes(n))

def tebibytes_to_exbibytes(n):
        return bytes_to_exbibytes(tebibytes_to_bytes(n))

def tebibytes_to_exabytes(n):
        return bytes_to_exabytes(tebibytes_to_bytes(n))

##
## Terabyte Conversions
##
def terabytes_to_bits(n):
        return n * 8000000000000.0

def terabytes_to_bytes(n):
        return n * 1000000000000.0

def terabytes_to_kibibytes(n):
        return bytes_to_kibibytes(terabytes_to_bytes(n))

def terabytes_to_kilobytes(n):
        return bytes_to_kilobytes(terabytes_to_bytes(n))

def terabytes_to_mebibytes(n):
        return bytes_to_mebibytes(terabytes_to_bytes(n))

def terabytes_to_megabytes(n):
        return bytes_to_megabytes(terabytes_to_bytes(n))

def terabytes_to_gibibytes(n):
        return bytes_to_gibibytes(terabytes_to_bytes(n))

def terabytes_to_gigabytes(n):
        return bytes_to_gigabytes(terabytes_to_bytes(n))

def terabytes_to_tebibytes(n):
        return bytes_to_tebibytes(terabytes_to_bytes(n))

def terabytes_to_terabytes(n):
        return n

def terabytes_to_pebibytes(n):
        return bytes_to_pebibytes(terabytes_to_bytes(n))

def terabytes_to_petabytes(n):
        return bytes_to_petabytes(terabytes_to_bytes(n))

def terabytes_to_exbibytes(n):
        return bytes_to_exbibytes(terabytes_to_bytes(n))

def terabytes_to_exabytes(n):
        return bytes_to_exabytes(terabytes_to_bytes(n))

##
## Pebibyte Conversions
##
def pebibytes_to_bits(n):
        return n * 9007199254740992.0

def pebibytes_to_bytes(n):
        return n * 1125899906842624.0

def pebibytes_to_kibibytes(n):
        return bytes_to_kibibytes(pebibytes_to_bytes(n))

def pebibytes_to_kilobytes(n):
        return bytes_to_kilobytes(pebibytes_to_bytes(n))

def pebibytes_to_mebibytes(n):
        return bytes_to_mebibytes(pebibytes_to_bytes(n))

def pebibytes_to_megabytes(n):
        return bytes_to_megabytes(pebibytes_to_bytes(n))

def pebibytes_to_gibibytes(n):
        return bytes_to_gibibytes(pebibytes_to_bytes(n))

def pebibytes_to_gigabytes(n):
        return bytes_to_gigabytes(pebibytes_to_bytes(n))

def pebibytes_to_tebibytes(n):
        return bytes_to_tebibytes(pebibytes_to_bytes(n))

def pebibytes_to_terabytes(n):
        return bytes_to_terabytes(pebibytes_to_bytes(n))

def pebibytes_to_pebibytes(n):
        return n

def pebibytes_to_petabytes(n):
        return bytes_to_petabytes(pebibytes_to_bytes(n))

def pebibytes_to_exbibytes(n):
        return bytes_to_exbibytes(pebibytes_to_bytes(n))

def pebibytes_to_exabytes(n):
        return bytes_to_exabytes(pebibytes_to_bytes(n))

##
## Petabyte Conversions
##
def petabytes_to_bits(n):
        return n * 8000000000000000.0

def petabytes_to_bytes(n):
        return n * 1000000000000000.0

def petabytes_to_kibibytes(n):
        return bytes_to_kibibytes(petabytes_to_bytes(n))

def petabytes_to_kilobytes(n):
        return bytes_to_kilobytes(petabytes_to_bytes(n))

def petabytes_to_mebibytes(n):
        return bytes_to_mebibytes(petabytes_to_bytes(n))

def petabytes_to_megabytes(n):
        return bytes_to_megabytes(petabytes_to_bytes(n))

def petabytes_to_gibibytes(n):
        return bytes_to_gibibytes(petabytes_to_bytes(n))

def petabytes_to_gigabytes(n):
        return bytes_to_gigabytes(petabytes_to_bytes(n))

def petabytes_to_tebibytes(n):
        return bytes_to_tebibytes(petabytes_to_bytes(n))

def petabytes_to_terabytes(n):
        return bytes_to_terabytes(petabytes_to_bytes(n))

def petabytes_to_pebibytes(n):
        return bytes_to_pebibytes(petabytes_to_bytes(n))

def petabytes_to_petabytes(n):
        return n

def petabytes_to_exbibytes(n):
        return bytes_to_exbibytes(petabytes_to_bytes(n))

def petabytes_to_exabytes(n):
        return bytes_to_exabytes(petabytes_to_bytes(n))

##
## Exbibyte Conversions
##
def exbibytes_to_bits(n):
        return n * 9223372036854775808.0

def exbibytes_to_bytes(n):
        return n * 1152921504606846976.0

def exbibytes_to_kibibytes(n):
        return bytes_to_kibibytes(exbibytes_to_bytes(n))

def exbibytes_to_kilobytes(n):
        return bytes_to_kilobytes(exbibytes_to_bytes(n))

def exbibytes_to_mebibytes(n):
        return bytes_to_mebibytes(exbibytes_to_bytes(n))

def exbibytes_to_megabytes(n):
        return bytes_to_megabytes(exbibytes_to_bytes(n))

def exbibytes_to_gibibytes(n):
        return bytes_to_gibibytes(exbibytes_to_bytes(n))

def exbibytes_to_gigabytes(n):
        return bytes_to_gigabytes(exbibytes_to_bytes(n))

def exbibytes_to_tebibytes(n):
        return bytes_to_tebibytes(exbibytes_to_bytes(n))

def exbibytes_to_terabytes(n):
        return bytes_to_terabytes(exbibytes_to_bytes(n))

def exbibytes_to_pebibytes(n):
        return bytes_to_pebibytes(exbibytes_to_bytes(n))

def exbibytes_to_petabytes(n):
        return bytes_to_petabytes(exbibytes_to_bytes(n))

def exbibytes_to_exbibytes(n):
        return n

def exbibytes_to_exabytes(n):
        return bytes_to_exabytes(exbibytes_to_bytes(n))

##
## Exabyte Conversions
##
def exabytes_to_bits(n):
        return n * 8000000000000000000.0

def exabytes_to_bytes(n):
        return n * 1000000000000000000.0

def exabytes_to_kibibytes(n):
        return bytes_to_kibibytes(exabytes_to_bytes(n))

def exabytes_to_kilobytes(n):
        return bytes_to_kilobytes(exabytes_to_bytes(n))

def exabytes_to_mebibytes(n):
        return bytes_to_mebibytes(exabytes_to_bytes(n))

def exabytes_to_megabytes(n):
        return bytes_to_megabytes(exabytes_to_bytes(n))

def exabytes_to_gibibytes(n):
        return bytes_to_gibibytes(exabytes_to_bytes(n))

def exabytes_to_gigabytes(n):
        return bytes_to_gigabytes(exabytes_to_bytes(n))

def exabytes_to_tebibytes(n):
        return bytes_to_tebibytes(exabytes_to_bytes(n))

def exabytes_to_terabytes(n):
        return bytes_to_terabytes(exabytes_to_bytes(n))

def exabytes_to_pebibytes(n):
        return bytes_to_pebibytes(exabytes_to_bytes(n))

def exabytes_to_petabytes(n):
        return bytes_to_petabytes(exabytes_to_bytes(n))

def exabytes_to_exbibytes(n):
        return bytes_to_exbibytes(exabytes_to_bytes(n))

def exabytes_to_exabytes(n):
        return n
