import re

import time
import datetime
import pytz

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...autotype import *
from ...streams import *

##
## bpmedialist has records separated by blank lines
##
def stream(stream, format='bpmedialist -mlist'):

    if format in ['bpmedialist -mlist']:
        return BlankLineStream(stream, header=2)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bpmedialist record
##
##     bpmedialist -L
##
def parse(record, format='bpmedialist -L', version=None, tz=None):

    re_pair = re.compile('^\s*([^:]+):\s*(.*)\s*$')
    re_type_id = re.compile('^([0-9a-zA-Z\-_ ]+)\s+\((\d+)\)$')
    re_unix_time_hack = re.compile('^.*\((\d+)\)$')
    re_trailing_whitespace = re.compile('\s+$')

    media = ExtendedDict()
    media['flags'] = ExtendedDict()

    if format == 'bpmedialist -L':

        try:

            for line in record:

                for pair in line.split(', '):

                    key, value = pair.split(' = ')

                    #
                    # convert text values to python datatypes
                    #
                    while True:

                        if key in ['allocated', 'last_written', 'expiration', 'last_read']:
                            match = re_unix_time_hack.match(value)
                            value = datetime.datetime.fromtimestamp(float(match.group(1)), tz)
                            break

                        if key in ['density']:
                            match = re_type_id.match(value)
                            idkey = '%s_id' % (key)
                            value = match.group(1)
                            media[idkey] = int(match.group(2))
                            break

                        if key in ['status']:
                            
                            value = int(value, 16)
                            status = ExtendedDict()

                            if value & 0x200 == 0x200:
                                media.flags.multiplexed = True
                            else:
                                media.flags.multiplexed = False

                            if value & 0x080 == 0x080:
                                media.flags.imported = True
                            else:
                                media.flags.imported = False
                            
                            if value & 0x040 == 0x040:
                                media.flags.multiple_retention_levels = True
                            else:
                                media.flags.multiple_retention_levels = False

                            if value & 0x008 == 0x008:
                                media.flags.full = True
                            else:
                                media.flags.full = False

                            if value & 0x004 == 0x004:
                                media.flags.unreported = True
                            else:
                                media.flags.unreported = False

                            if value & 0x002 == 0x002:
                                media.flags.suspended = True
                            else:
                                media.flags.suspended = False

                            if value & 0x001 == 0x001:
                                media.flags.frozen = True
                            else:
                                media.flags.frozen = False

                            if value & 0x000 == 0x000:
                                media.flags.active = True
                            else:
                                media.flags.active = False

                            break

                        if value in['*NULL*']:
                            value = None
                            break

                        value = autotype(value)
                        break

                    media[key] = value

            return media

        except Exception, e:

            for line in record:
                print line

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

