#!/usr/bin/python26
###
### backmon.commands.check.jobs
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser
from guppy import hpy

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import bpdbjobs

usage = 'usage: %prog -e [environment] check jobs'

parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    master_feeds    = ['nbemmcmd_machinealias_getaliases', 'bpdbjobs_most_columns']
    media_feeds     = [ ]

    if not ENVIRONMENT:
        ERROR('Must specify backup environment!')
        sys.exit(1) 

    try:

        environment = ENVIRONMENTS[ENVIRONMENT]

        hp = hpy()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        environment.load_feeds(master=master_feeds, media=media_feeds)
        environment.parse_jobs()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        active_backups          = 0
        queued_backups          = 0
        suspended_backups       = 0
        incomplete_backups      = 0

        active_restores         = 0
        queued_restores         = 0
        suspended_restores      = 0
        incomplete_restores     = 0

        active_duplications     = 0
        queued_duplications     = 0
        suspended_duplications  = 0
        incomplete_duplications = 0

        i = 0
        j = 0

        for job in environment.jobs:

            i += 1

            if job.jobtype == 'backup':

                if job.active:
                    active_backups += 1
                    continue

                if job.queued:
                    queued_backups += 1
                    continue

                if job.state == 'suspended':
                    suspended_backups += 1
                    continue

                if job.state == 'incomplete':
                    incomplete_backups += 1
                    continue

            if job.jobtype == 'restore':

                if job.active:
                    active_restores += 1
                    continue

                if job.queued:
                    queued_restores += 1
                    continue

                if job.state == 'suspended':
                    suspended_restores += 1
                    continue

                if job.state == 'incomplete':
                    incomplete_restores += 1
                    continue

            if job.jobtype == 'duplication':

                if job.active:
                    active_duplications += 1
                    continue

                if job.queued:
                    queued_duplications += 1
                    continue

                if job.state == 'suspended':
                    suspended_duplications += 1
                    continue

                if job.state == 'incomplete':
                    incomplete_duplications += 1
                    continue

        if i == 0:

            perfdata = 'backups=-1;-1;-1;-1 restores=-1;-1;-1;-1 duplications=-1;-1;-1;-1'
            print('bpdbjobs output is empty! | %s' % (perfdata))
            sys.exit(2)

        else:

            perfdata = 'backups=%d;%d;%d;%d restores=%d;%d;%d;%d duplications=%d;%d;%d;%d' % (active_backups, queued_backups, suspended_backups, incomplete_backups, active_restores, queued_restores, suspended_restores, incomplete_restores, active_duplications, queued_duplications, suspended_duplications, incomplete_duplications)
            print('OK: bpdbjobs contains %d jobs of all types | %s' % (i, perfdata))
            sys.exit(0)

    except Exception, e:

        raise

