import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## du has one record per-line
##
def stream(stream, format='du -k'):

    if format in ['du -k']:
        return NewLineStream(stream, header=0)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a du record
##
##     du -k
##
def parse(record, format='du -k', version=None, tz=None):

    fs = ExtendedDict()

    if format == 'du -k':

        regex = re.compile('^(\d+)\s+(.*)$')

        try:

            match = regex.match(record)

            fs['kbytes']    = long(match.group(1))
            fs['path']      = match.group(2)

            return fs

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
