import re
import datetime


##
## Match a decimal integer
##
re_integer = re.compile('^\d+$')

##
## Match a floating point value
##
re_float = re.compile('^\d+\.\d+$')

##
## Scientific E Notation
##
##     +4.57087000000000E+002
##
re_enotation = re.compile('^([+-])?(\d+)\.(\d+)[eE]([+-])(\d+)$')


##
## SQL DATETIME
##
re_sql_datetime = re.compile('^(\d\d\d\d)-(\d\d)-(\d\d) (\d\d):(\d\d):(\d\d)\.?(\d*)$')


##
## autotype()
##
def autotype(value, tz=None):

    #
    # Convert to integer value
    #
    match = re_integer.match(value)
    if match:
        return int(value)

    #
    # Convert to float value
    #
    match = re_float.match(value)
    if match:
        return float(value)

    #
    # Scientific E Notation
    #
    match = re_enotation.match(value)
    if match:
        sign = match.group(1)
        number = match.group(2)
        decimal = match.group(3)
        esign = match.group(4)
        exponent = match.group(5)

        number = float('%s%s.%s' % (sign, number, decimal))
        exponent = float('%s%s' % (esign, exponent))

        return round((number) * (10**exponent), 6)

        #if len(number) < exponent:
        #    lpad = exponent
        #else:
        #    lpad = 0
        #if len(decimal) < exponent:
        #    rpad = exponent
        #else:
        #    rpad = 0

        #ipos = exponent + len(number) + 1

        #digits = '%s%s%s%s' % (exponent * '0', number, decimal, exponent * '0') # combined string of all digits with padding

        #npos = ipos

        #r = '%s.%s' % (digits[:npos], digits[npos:])
        #return float(r)

    #
    # SQL DATETIME
    #
    match = re_sql_datetime.match(value)
    if match:
        year = int(match.group(1))
        month = int(match.group(2))
        day = int(match.group(3))
        hour = int(match.group(4))
        minute = int(match.group(5))
        second = int(match.group(6))
        microsecond = int(match.group(7))
        return datetime.datetime(year=year, month=month, day=day, hour=hour, minute=minute, second=second, microsecond=microsecond, tzinfo=tz)

    #
    # Line Terminated String
    #
    if len(value) >= 1:
        if value[-1] == '\n':
            return value[:-1]

    #
    # Default
    #
    return value
