#!/usr/bin/python26
###
### backmon.commands.alias
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser

from ..lib import *

usage = 'usage: %prog -e environment alias'

parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    if not OPTIONS.environment:
        ERROR('Please specify an environment to use the alias command.')
        sys.exit(1)
    elif( len(args) == 0 ):
        ERROR('No alias specified.')
        sys.exit(1)
    else:
        alias = args.pop(0)
        DEBUG('ALIAS=%s' % (alias))

        environment = ENVIRONMENTS[ENVIRONMENT]

        environment.refresh(['aliases'])
        environment.parse_aliases()

        if alias not in environment.aliases:
            ERROR('No aliases were found for the alias "%s"' % (alias))
        else:
            for alias in environment.aliases[alias]:
                if alias in SERVER_PATHS:
                    print alias
#                    print SERVER_PATHS[alias]

