
import time
import pytz

from backup_monitoring.parsing.parsers import bpdbjobs as parser

file = open('test.txt', 'r')

stream = parser.stream(file)

i = 0

tz = pytz.timezone('CET')

for record in stream:

    i += 1

    job = parser.parse(record, tz=tz)

    jobid   = job.jobid
    jobtype = job.jobtype
    state   = job.state
    started = job.started
    stunit  = job.stunit

    if jobtype == 'backup' and jobid == 218840:

        print 'jobid=%d, started=%s' % (jobid, started)

        time.sleep(1)

file.close()
