import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *
from ...autotype import *

re_error = re.compile('^AN[RS]\d+E .*$')
re_no_match_found = re.compile('^ANR2034E SELECT: No match found using this criteria.*$')
re_session_rejected = re.compile('^ANS1017E Session rejected: TCP/IP connection failure.*$')
re_unable_to_establish_session = re.compile('ANS8023E Unable to establish session with server.*$')

##
## dsmadmc records
##
def stream(stream, format='dsmadmc -dataonly=yes -displaymode=list'):

    if format in ['dsmadmc -dataonly=yes -displaymode=list']:
        return BlankLineStream(stream, header=0)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a dsmadmc record
##
##     dsmadmc -dataonly=yes -displaymode=list
##
def parse(record, format='dsmadmc -dataonly=yes -displaymode=list', version=None, tz=None):

    obj = ExtendedDict()
    re_pair = re.compile('^\s*([^:]+):\s+(.*)$')

    if format == 'dsmadmc -dataonly=yes -displaymode=list':

        try:

            for line in record:

                if re_error.match(line):
                    return None

                #if re_no_match_found.match(line):
                #    return None

                #if re_session_rejected(line):
                #    return None

                #if re_unable_to_establish_session:
                #    return None

                match = re_pair.match(line)

                key = match.group(1)
                value = match.group(2)
                key = key.lower()
                key = key.replace(' ', '_')
                key = key.replace('/', '_')
                key = key.replace('\\', '_')
                key = key.replace('?', '')
                key = key.replace('.', '')

                value = autotype(value, tz=tz)

                #if value == '':
                #    value = None

                obj[key] = value

            return obj

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)


